/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.listener;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class ListenerUtil {
    private static Map<Class<? extends Listener>, Listener> classListenerInstanceMap = new LinkedHashMap<Class<? extends Listener>, Listener>();

    public static void register(@NonNull Class<? extends Listener> listener, @NonNull Plugin plugin) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        try {
            Listener instance = listener.newInstance();
            plugin.getServer().getPluginManager().registerEvents(instance, plugin);
            classListenerInstanceMap.put(listener, instance);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void unregister(@NonNull Class<? extends Listener> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        try {
            Listener instance = classListenerInstanceMap.get(listener);
            HandlerList.unregisterAll((Listener)instance);
            classListenerInstanceMap.remove(listener);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ListenerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

