/*
 * Decompiled with CFR 0.152.
 */
package net.jest.implementation;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import net.jest.JestServer;
import net.jest.api.Controller;
import net.jest.api.response.Response;
import net.jest.api.util.ResponseUtil;
import net.jest.reflect.MethodParser;
import net.jest.request.Request;
import net.jest.util.DebugUtil;
import net.jest.util.ExchangeUtil;

public class RealJestServer
implements JestServer {
    private final Map<String, Function<Request, Response>> patchRequestHandlerMap = new LinkedHashMap<String, Function<Request, Response>>();
    private int port;
    private String host;

    @Override
    public void registerRestController(@NonNull Class<?> controllerClass) {
        if (controllerClass == null) {
            throw new NullPointerException("controllerClass is marked non-null but is null");
        }
        Controller controller = controllerClass.getDeclaredAnnotation(Controller.class);
        if (controller == null) {
            throw new IllegalArgumentException(controllerClass.getName() + " don't has @Controller annotation!");
        }
        try {
            Object controllerInstance = controllerClass.newInstance();
            for (Method method : controllerClass.getDeclaredMethods()) {
                Function<Request, Response> function = MethodParser.parse(controller, controllerInstance, method);
                String path = MethodParser.getName(controller, method);
                if (function == null) continue;
                this.patchRequestHandlerMap.put(path, function);
                DebugUtil.print("Success registered %s restful-method", path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        DebugUtil.print("Try boot Jest-Server instance on ip `%s:%s`", this.host, this.port);
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(this.host, this.port), 0);
            server.createContext("/", exchange -> {
                long startMills = System.currentTimeMillis();
                String path = exchange.getRequestURI().getRawPath();
                String query = exchange.getRequestURI().getRawQuery();
                DebugUtil.print("Try handle new request: `%s/%s`", path, query);
                Response response = this.findResponse(path, exchange);
                ExchangeUtil.returnString(exchange, response.getOutput(), response.getStatusCode());
                DebugUtil.print("Success handle request: `%s/%s`, with %sms", path, query, System.currentTimeMillis() - startMills);
            });
            server.setExecutor(null);
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Response findResponse(@NonNull String path, HttpExchange exchange) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Function<Request, Response> method = this.patchRequestHandlerMap.get(path.toLowerCase());
        return method == null ? ResponseUtil.createResponse(404, "This method was not found.") : method.apply(Request.fromExchange(exchange));
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

