/*
 * Decompiled with CFR 0.152.
 */
package net.jest.reflect;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.NonNull;
import net.jest.api.Controller;
import net.jest.api.Method;
import net.jest.api.RequiredAuth;
import net.jest.api.response.Response;
import net.jest.api.util.ResponseUtil;
import net.jest.request.Request;
import net.jest.util.CacheUtil;

public final class MethodParser {
    public static String getName(@NonNull Controller controller, @NonNull java.lang.reflect.Method method) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        Method annotation = method.getDeclaredAnnotation(Method.class);
        if (annotation == null) {
            return null;
        }
        String path = controller.path() + annotation.name();
        return path;
    }

    public static Function<Request, Response> parse(@NonNull Controller controller, @NonNull Object instance, @NonNull java.lang.reflect.Method method) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        String path = MethodParser.getName(controller, method);
        if (path == null) {
            return null;
        }
        HashMap parameters = new HashMap();
        for (Parameter parameter : method.getParameters()) {
            parameters.put(parameter.getType(), parameter.getAnnotation(net.jest.api.Parameter.class).value());
        }
        RequiredAuth auth = method.getDeclaredAnnotation(RequiredAuth.class);
        return request -> {
            if (auth != null && CacheUtil.putIfAbsent(auth.value()) != null && !CacheUtil.putIfAbsent(auth.value()).isAuthorized(request.getExchange(), (Request)request)) {
                return ResponseUtil.createResponse(401, "Cant authorize your request. Please read api documentation. (The message is generated by the Jest framework)");
            }
            if (parameters.size() > request.getParameters().size()) {
                return ResponseUtil.createResponse(400, "You have not specified enough parameters. Read the documentation. (The message is generated by the Jest framework)");
            }
            AtomicReference<Object> response = new AtomicReference<Object>(null);
            ArrayList parametersInvoke = new ArrayList();
            parameters.forEach((type, name) -> {
                try {
                    if (request.getParameter(type, (String)name) == null) {
                        response.set(ResponseUtil.createResponse(400, "The " + name + " argument was not found, or the wrong type was specified. (The message is generated by the Jest framework)"));
                    } else {
                        parametersInvoke.add(request.getParameter(type, (String)name));
                    }
                }
                catch (Exception e) {
                    response.set(ResponseUtil.createResponse(500, "Internal server error during process request. (The message is generated by the Jest framework)"));
                }
            });
            if (response.get() != null) {
                return response.get();
            }
            try {
                if (method.getReturnType().isAssignableFrom(Response.class) || method.getReturnType().equals(Response.class)) {
                    return (Response)(parametersInvoke.isEmpty() ? method.invoke(instance, new Object[0]) : method.invoke(instance, parametersInvoke.toArray(new Object[1])));
                }
                return ResponseUtil.createResponse(200, method.invoke(instance, parametersInvoke.toArray(new Object[1])));
            }
            catch (Exception e) {
                return ResponseUtil.createResponse(500, "Internal server error during method invoke. (The message is generated by the Jest framework)");
            }
        };
    }

    private MethodParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

