/*
 * Decompiled with CFR 0.152.
 */
package net.jest.request;

import com.sun.net.httpserver.HttpExchange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import sun.net.www.ParseUtil;

public class Request {
    private Map<Object, List<Object>> parameters;
    private HttpExchange exchange;

    public <T> T getParameter(@NonNull Class<T> parameterClass, @NonNull String parameterName) {
        if (parameterClass == null) {
            throw new NullPointerException("parameterClass is marked non-null but is null");
        }
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        try {
            if (parameterClass.equals(Integer.TYPE) || parameterClass.equals(Long.TYPE) || parameterClass.equals(Short.TYPE)) {
                return (T)Integer.valueOf(Integer.parseInt(this.parameters.get(parameterName).get(0).toString()));
            }
            if (parameterClass.isAssignableFrom(Collection.class)) {
                return (T)this.parameters.get(parameterName);
            }
            return (T)this.parameters.get(parameterName).stream().findFirst().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean containsParameter(@NonNull String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        return this.parameters.containsKey(parameterName);
    }

    public static Request fromExchange(HttpExchange exchange) {
        String query = exchange.getRequestURI().getRawQuery();
        if (query == null || "".equals(query) || "null".equals(query)) {
            return new Request(Collections.emptyMap(), exchange);
        }
        return new Request(Pattern.compile("&").splitAsStream(query).map(s -> Arrays.copyOf(s.split("="), 2)).collect(Collectors.groupingBy(s -> ParseUtil.decode(s[0]), Collectors.mapping(s -> ParseUtil.decode(s[1]), Collectors.toList()))), exchange);
    }

    public Map<Object, List<Object>> getParameters() {
        return this.parameters;
    }

    public HttpExchange getExchange() {
        return this.exchange;
    }

    public Request(Map<Object, List<Object>> parameters, HttpExchange exchange) {
        this.parameters = parameters;
        this.exchange = exchange;
    }
}

