/*
 * Decompiled with CFR 0.152.
 */
package net.jest;

import lombok.NonNull;
import net.jest.JestServer;
import net.jest.api.JestBootstrap;
import net.jest.implementation.RealJestServer;

public final class JestInitializer {
    public static JestServer bootServer(@NonNull Class<?> bootClass) {
        if (bootClass == null) {
            throw new NullPointerException("bootClass is marked non-null but is null");
        }
        JestBootstrap bootstrap = bootClass.getAnnotation(JestBootstrap.class);
        if (bootstrap == null) {
            throw new IllegalArgumentException("Not found @JestBootstrap annotation at " + bootClass.getName());
        }
        RealJestServer jestServer = new RealJestServer();
        jestServer.setHost(bootstrap.hostName());
        jestServer.setPort(bootstrap.port());
        jestServer.setTls(bootstrap.tls());
        jestServer.run();
        return jestServer;
    }

    private JestInitializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

