/*
 * Decompiled with CFR 0.152.
 */
package net.jest.implementation;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import lombok.NonNull;
import net.jest.JestServer;
import net.jest.api.Controller;
import net.jest.api.response.Response;
import net.jest.api.util.ResponseUtil;
import net.jest.implementation.request.RealRequestSource;
import net.jest.reflect.MethodParser;
import net.jest.util.DebugUtil;
import net.jest.util.ExchangeUtil;

public class RealJestServer
implements JestServer {
    private final Map<String, Function<RealRequestSource, Response>> patchRequestHandlerMap = new LinkedHashMap<String, Function<RealRequestSource, Response>>();
    private int port;
    private String tls;
    private String host;

    @Override
    public void registerRestController(@NonNull Class<?> controllerClass) {
        if (controllerClass == null) {
            throw new NullPointerException("controllerClass is marked non-null but is null");
        }
        Controller controller = controllerClass.getDeclaredAnnotation(Controller.class);
        if (controller == null) {
            throw new IllegalArgumentException(controllerClass.getName() + " don't has @Controller annotation!");
        }
        try {
            Object controllerInstance = controllerClass.newInstance();
            for (Method method : controllerClass.getDeclaredMethods()) {
                Function<RealRequestSource, Response> function = MethodParser.parse(controller, controllerInstance, method);
                String path = MethodParser.getName(controller, method);
                if (function == null) continue;
                this.patchRequestHandlerMap.put(path, function);
                DebugUtil.print("Success registered %s restful-method", path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerRestController(@NonNull Object instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        Controller controller = instance.getClass().getDeclaredAnnotation(Controller.class);
        if (controller == null) {
            throw new IllegalArgumentException(instance.getClass().getName() + " don't has @Controller annotation!");
        }
        try {
            for (Method method : instance.getClass().getDeclaredMethods()) {
                Function<RealRequestSource, Response> function = MethodParser.parse(controller, instance, method);
                String path = MethodParser.getName(controller, method);
                if (function == null) continue;
                this.patchRequestHandlerMap.put(path, function);
                DebugUtil.print("Success registered %s restful-method.", path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        DebugUtil.print("Try boot Jest-Server instance on ip `%s:%s`", this.host, this.port);
        try {
            HttpServer server;
            HttpServer httpServer = server = this.tls != null ? HttpsServer.create(new InetSocketAddress(this.host, this.port), 0) : HttpServer.create(new InetSocketAddress(this.host, this.port), 0);
            if (this.tls != null) {
                this.initializeTLS((HttpsServer)server);
            }
            server.createContext("/", exchange -> {
                long startMills = System.currentTimeMillis();
                String path = exchange.getRequestURI().getRawPath();
                String query = exchange.getRequestURI().getRawQuery();
                DebugUtil.print("Try handle new request: `%s/%s`", path, query);
                Response response = this.findResponse(path, exchange);
                ExchangeUtil.returnString(exchange, response.getOutput(), response.getStatusCode());
                DebugUtil.print("Success handle request: `%s/%s`, with %sms", path, query, System.currentTimeMillis() - startMills);
            });
            server.setExecutor(null);
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeTLS(@NonNull HttpsServer server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            char[] password = this.tls.toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream("lig.keystore");
            ks.load(fis, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters params) {
                    try {
                        SSLContext c = SSLContext.getDefault();
                        SSLEngine engine = c.createSSLEngine();
                        params.setNeedClientAuth(false);
                        params.setCipherSuites(engine.getEnabledCipherSuites());
                        params.setProtocols(engine.getEnabledProtocols());
                        SSLParameters defaultSSLParameters = c.getDefaultSSLParameters();
                        params.setSSLParameters(defaultSSLParameters);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Response findResponse(@NonNull String path, HttpExchange exchange) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Function<RealRequestSource, Response> method = this.patchRequestHandlerMap.get(path.toLowerCase());
        return method == null ? ResponseUtil.createResponse(404, "This method was not found.") : method.apply(RealRequestSource.fromExchange(exchange));
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTls(String tls) {
        this.tls = tls;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

