/*
 * Decompiled with CFR 0.152.
 */
package net.lithe.adept.implementation;

import lombok.NonNull;
import net.lithe.Score;
import net.lithe.adept.AbstractAdept;
import net.lithe.injectior.implementation.RealInjector;

public abstract class SimpleAdept
implements AbstractAdept {
    private final RealInjector injector = new RealInjector();

    @Override
    public <T> void register(@NonNull Score score, @NonNull Class<T> abstractClass, @NonNull Class<? extends T> implementation) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        if (abstractClass == null) {
            throw new NullPointerException("abstractClass is marked non-null but is null");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation is marked non-null but is null");
        }
        switch (score) {
            case PROTOTYPE: {
                this.injector.getPrototypeMap().put(abstractClass, implementation);
                break;
            }
            case SINGLETON: {
                try {
                    this.injector.getSingletonMap().put(abstractClass, implementation.newInstance());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public <T> void registerSingleton(@NonNull Class<T> abstractClass, @NonNull T implementationInstance) {
        if (abstractClass == null) {
            throw new NullPointerException("abstractClass is marked non-null but is null");
        }
        if (implementationInstance == null) {
            throw new NullPointerException("implementationInstance is marked non-null but is null");
        }
        this.injector.getSingletonMap().put(abstractClass, implementationInstance);
    }

    @Override
    public <T> void register(@NonNull Score score, @NonNull Class<T> tClass) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        if (tClass == null) {
            throw new NullPointerException("tClass is marked non-null but is null");
        }
        switch (score) {
            case PROTOTYPE: {
                this.injector.getPrototypeMap().put(tClass, tClass);
                break;
            }
            case SINGLETON: {
                try {
                    this.injector.getSingletonMap().put(tClass, tClass.newInstance());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public <T> void registerSingleton(@NonNull T instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.injector.getSingletonMap().put(instance.getClass(), instance);
    }

    @Override
    public RealInjector getInjector() {
        return this.injector;
    }
}

