/*
 * Decompiled with CFR 0.152.
 */
package net.lithe.injectior.implementation;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import net.lithe.injectior.Inject;
import net.lithe.injectior.Injector;

public class RealInjector
implements Injector {
    private final Map<Class<?>, Object> singletonMap = new LinkedHashMap();
    private final Map<Class<?>, Class<?>> prototypeMap = new LinkedHashMap();

    @Override
    public <T> T getInstance(@NonNull Class<T> t) {
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        try {
            return (T)(this.singletonMap.containsKey(t) ? this.singletonMap.get(t) : this.createInstance(t));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postInitialize() {
        this.singletonMap.forEach((abstractClass, implementationInstance) -> {
            for (Field field : implementationInstance.getClass().getDeclaredFields()) {
                this.injectDeclaredField(field, implementationInstance);
            }
        });
    }

    private void injectDeclaredField(@NonNull Field field, @NonNull Object instance) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (field.getDeclaredAnnotation(Inject.class) == null) {
            return;
        }
        try {
            if (this.singletonMap.containsKey(field.getType())) {
                field.setAccessible(true);
                field.set(instance, this.singletonMap.get(field.getType()));
                return;
            }
            if (this.prototypeMap.containsKey(field.getType())) {
                field.setAccessible(true);
                field.set(instance, this.createInstance(field.getType()));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public <T> T createInstance(@NonNull Class<T> tClass) {
        if (tClass == null) {
            throw new NullPointerException("tClass is marked non-null but is null");
        }
        try {
            T t = tClass.newInstance();
            for (Field field : tClass.getDeclaredFields()) {
                this.injectDeclaredField(field, t);
            }
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Map<Class<?>, Object> getSingletonMap() {
        return this.singletonMap;
    }

    public Map<Class<?>, Class<?>> getPrototypeMap() {
        return this.prototypeMap;
    }
}

