/*
 * Decompiled with CFR 0.152.
 */
package net.lithe.automatic;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.stream.Collectors;

public final class AccessingAllClassesInPackage {
    public static Set<Class> findAllClassesUsingClassLoader(String packageName) {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        return reader.lines().filter(line -> line.endsWith(".class")).map(line -> AccessingAllClassesInPackage.getClass(line, packageName)).collect(Collectors.toSet());
    }

    private static Class getClass(String className, String packageName) {
        try {
            return Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private AccessingAllClassesInPackage() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

