/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib;

import lombok.NonNull;
import net.pxstudios.minelib.asynccatcher.AsyncCatcherBypass;
import net.pxstudios.minelib.beat.BukkitBeater;
import net.pxstudios.minelib.beat.wrapper.WrapperBukkitTask;
import net.pxstudios.minelib.board.BoardApi;
import net.pxstudios.minelib.command.CommandRegistry;
import net.pxstudios.minelib.common.chat.ChatApi;
import net.pxstudios.minelib.common.config.PluginConfigManager;
import net.pxstudios.minelib.common.item.BukkitItemApi;
import net.pxstudios.minelib.common.item.event.BukkitItemEventsHandler;
import net.pxstudios.minelib.common.location.BukkitLocationApi;
import net.pxstudios.minelib.cooldown.PlayerCooldownApi;
import net.pxstudios.minelib.event.bukkit.BukkitEventsWrapperListener;
import net.pxstudios.minelib.fastutil.FastUtils;
import net.pxstudios.minelib.gui.GuiManager;
import net.pxstudios.minelib.motd.ServerMotdApi;
import net.pxstudios.minelib.permission.PlayerPermissionApi;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.registry.BukkitRegistryManager;
import net.pxstudios.minelib.subscription.EventsSubscriber;
import net.pxstudios.minelib.world.BukkitWorldsApi;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class MineLibrary {
    private AsyncCatcherBypass asyncCatcherBypass;
    private CommandRegistry commandRegistry;
    private BukkitBeater beater;
    private BoardApi boardApi;
    private ChatApi chatApi;
    private PluginConfigManager configManager;
    private GuiManager guiManager;
    private PlayerCooldownApi playerCooldownApi;
    private EventsSubscriber eventsSubscriber;
    private FastUtils fastUtils;
    private BukkitItemApi itemApi;
    private BukkitLocationApi locationApi;
    private ServerMotdApi serverMotdApi;
    private PlayerPermissionApi permissionApi;
    private BukkitWorldsApi worldsApi;
    private BukkitRegistryManager registryManager;
    private WrapperBukkitTask autoGarbageCollectorTask;

    public void init(@NonNull MinecraftPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.asyncCatcherBypass = new AsyncCatcherBypass(plugin);
        this.commandRegistry = new CommandRegistry(plugin);
        this.beater = new BukkitBeater(plugin);
        this.eventsSubscriber = new EventsSubscriber(plugin);
        this.fastUtils = new FastUtils(plugin);
        this.registryManager = new BukkitRegistryManager(plugin);
        this.boardApi = new BoardApi(plugin);
        this.worldsApi = new BukkitWorldsApi(plugin);
        this.playerCooldownApi = new PlayerCooldownApi(plugin);
        this.guiManager = new GuiManager(plugin);
        this.serverMotdApi = new ServerMotdApi(plugin);
        this.permissionApi = new PlayerPermissionApi(plugin);
        this.chatApi = new ChatApi();
        this.configManager = new PluginConfigManager();
        this.itemApi = new BukkitItemApi();
        this.locationApi = new BukkitLocationApi();
        this.registryManager.addDefaultProviders();
        this.configManager.addDefaultProviders();
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new BukkitItemEventsHandler(), (Plugin)plugin);
        pluginManager.registerEvents((Listener)new BukkitEventsWrapperListener(this), (Plugin)plugin);
        pluginManager.registerEvents((Listener)this.guiManager.getListener(), (Plugin)plugin);
    }

    public void runAutoGarbageCollector() {
        this.autoGarbageCollectorTask = this.beater.runTimerAsync(300L, System::gc);
        this.autoGarbageCollectorTask.waitAfter(() -> Bukkit.getLogger().info("Auto garbage-collector is disabled!"));
    }

    public void destroyAutoGarbageCollector() {
        if (!this.autoGarbageCollectorTask.isCancelled()) {
            this.autoGarbageCollectorTask.cancel();
        }
    }

    public AsyncCatcherBypass getAsyncCatcherBypass() {
        return this.asyncCatcherBypass;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public BukkitBeater getBeater() {
        return this.beater;
    }

    public BoardApi getBoardApi() {
        return this.boardApi;
    }

    public ChatApi getChatApi() {
        return this.chatApi;
    }

    public PluginConfigManager getConfigManager() {
        return this.configManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public PlayerCooldownApi getPlayerCooldownApi() {
        return this.playerCooldownApi;
    }

    public EventsSubscriber getEventsSubscriber() {
        return this.eventsSubscriber;
    }

    public FastUtils getFastUtils() {
        return this.fastUtils;
    }

    public BukkitItemApi getItemApi() {
        return this.itemApi;
    }

    public BukkitLocationApi getLocationApi() {
        return this.locationApi;
    }

    public ServerMotdApi getServerMotdApi() {
        return this.serverMotdApi;
    }

    public PlayerPermissionApi getPermissionApi() {
        return this.permissionApi;
    }

    public BukkitWorldsApi getWorldsApi() {
        return this.worldsApi;
    }

    public BukkitRegistryManager getRegistryManager() {
        return this.registryManager;
    }
}

