/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.board;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.pxstudios.minelib.board.Board;
import net.pxstudios.minelib.board.BoardObjective;
import net.pxstudios.minelib.board.BoardPresetsManager;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;

public final class BoardApi {
    public static final int MAX_NAME_LENGTH = 16;
    public static final String DUMMY_CRITERIA = "dummy";
    public static final char[] BLANK_LINE_CHARS_BY_POSITION = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'r'};
    private final MinecraftPlugin plugin;
    private final Map<String, Board> createdBoardsMap = new HashMap<String, Board>();
    private final BoardPresetsManager globalPresetsManager = new BoardPresetsManager();

    private String substringNameLength(String name) {
        return name.length() > 16 ? name.substring(0, 16) : name;
    }

    public BoardPresetsManager createPresetsManager() {
        return new BoardPresetsManager();
    }

    public Board createOrGetBoard(DisplaySlot display, String name, String criteria) {
        return this.createdBoardsMap.computeIfAbsent(this.substringNameLength(name), f -> new Board(this, display, this.substringNameLength(name), criteria));
    }

    public Board createOrGetBoard(String name) {
        return this.createOrGetBoard(DisplaySlot.SIDEBAR, name, DUMMY_CRITERIA);
    }

    public Board createOrGetBoard(DisplaySlot display, String name) {
        return this.createOrGetBoard(display, name, DUMMY_CRITERIA);
    }

    public Board createOrGetBoard(String name, String criteria) {
        return this.createOrGetBoard(DisplaySlot.SIDEBAR, name, criteria);
    }

    public BoardObjective createObjective(Board board, DisplaySlot display, String name, String criteria) {
        return new BoardObjective(board, display, name, criteria);
    }

    public BoardObjective createObjective(Board board, String name, String criteria) {
        return this.createObjective(board, DisplaySlot.SIDEBAR, name, criteria);
    }

    public BoardObjective createObjective(Board board, String name) {
        return this.createObjective(board, DisplaySlot.SIDEBAR, name, DUMMY_CRITERIA);
    }

    public BoardObjective createObjective(Board board, DisplaySlot display, String name) {
        return this.createObjective(board, display, name, DUMMY_CRITERIA);
    }

    public Board getActiveBoard(Player player) {
        for (Board board : this.createdBoardsMap.values()) {
            if (!board.isViewing(player)) continue;
            return board;
        }
        return null;
    }

    public void removeBoard(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Board board = this.createdBoardsMap.remove(this.substringNameLength(name));
        if (board != null) {
            board.getPlayersViews().forEach(board::removePlayerView);
        }
    }

    public BoardApi(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public MinecraftPlugin getPlugin() {
        return this.plugin;
    }

    public BoardPresetsManager getGlobalPresetsManager() {
        return this.globalPresetsManager;
    }
}

