/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.board;

import java.util.function.Function;
import net.pxstudios.minelib.board.Board;
import org.bukkit.entity.Player;

public class BoardField {
    private final Board board;
    private Function<Player, String> textGetter;
    private final int position;
    private boolean isStatic;

    public final BoardField setModifiableText(Function<Player, String> textGetter) {
        this.isStatic = false;
        this.textGetter = textGetter;
        return this;
    }

    public final BoardField setStaticText(String text) {
        this.isStatic = true;
        return this.setModifiableText(player -> text);
    }

    public final String getStaticText() {
        return this.isStatic ? this.textGetter.apply(null) : null;
    }

    public final String getModifiableText(Player player) {
        return !this.isStatic ? this.textGetter.apply(player) : null;
    }

    protected void sendUpdate(Player player) {
    }

    protected void sendCreate(Player player) {
    }

    protected void sendRemove(Player player) {
    }

    void sendAction(Player player, Action action) {
        switch (action) {
            case UPDATE: {
                this.sendUpdate(player);
                break;
            }
            case CREATE: {
                this.sendCreate(player);
                break;
            }
            case REMOVE: {
                this.sendRemove(player);
            }
        }
    }

    public BoardField(Board board, int position) {
        this.board = board;
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    static enum Action {
        UPDATE,
        CREATE,
        REMOVE;

    }
}

