/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.command;

import java.util.HashSet;
import lombok.NonNull;
import net.pxstudios.minelib.command.BukkitCommandExecuteWrapper;
import net.pxstudios.minelib.command.type.AbstractContextCommand;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

public final class CommandRegistry {
    private final MinecraftPlugin plugin;
    private CommandMap cachedCommandMap;

    private CommandMap injectCommandMap(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (this.cachedCommandMap == null) {
            this.cachedCommandMap = (CommandMap)server.getClass().getDeclaredField("commandMap").get(server);
        }
        return this.cachedCommandMap;
    }

    private void registerCommandWrapper(@NonNull BukkitCommandExecuteWrapper commandExecuteWrapper) {
        if (commandExecuteWrapper == null) {
            throw new NullPointerException("commandExecuteWrapper is marked non-null but is null");
        }
        CommandMap commandMap = this.injectCommandMap(this.plugin.getServer());
        String fallbackPrefix = this.plugin.getName();
        commandMap.register(commandExecuteWrapper.getName(), fallbackPrefix, (Command)commandExecuteWrapper);
    }

    public void registerCommand(AbstractContextCommand abstractContextCommand, String name, String ... aliases) {
        this.registerCommandWrapper(new BukkitCommandExecuteWrapper(abstractContextCommand, name, aliases));
    }

    public void registerCommand(AbstractContextCommand abstractContextCommand) {
        HashSet<String> activeLabels = new HashSet<String>(abstractContextCommand.getActiveLabels());
        if (activeLabels.isEmpty()) {
            throw new IllegalArgumentException("No command labels found");
        }
        String name = (String)activeLabels.iterator().next();
        activeLabels.remove(name);
        this.registerCommand(abstractContextCommand, name, activeLabels.toArray(new String[0]));
    }

    public CommandRegistry(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }
}

