/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.chat;

import java.util.function.Predicate;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import net.pxstudios.minelib.common.chat.ChatDirection;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public final class ChatApi {
    private static final Server SERVER = Bukkit.getServer();

    public void sendMessage(ChatDirection direction, Player player, String message, Predicate<Player> predicate) {
        if (direction == null) {
            direction = ChatDirection.CHAT;
        }
        if (predicate != null && !predicate.test(player)) {
            return;
        }
        switch (direction) {
            case CHAT: {
                player.sendMessage(message);
                break;
            }
            case ACTIONBAR: {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                break;
            }
            case TITLE: {
                player.sendTitle(message, "");
                break;
            }
            case SUBTITLE: {
                player.sendTitle("", message);
            }
        }
    }

    public void sendMessage(ChatDirection direction, Player player, String message) {
        this.sendMessage(direction, player, message, (Predicate<Player>)null);
    }

    public void sendMessage(Player player, String message) {
        this.sendMessage(ChatDirection.CHAT, player, message, (Predicate<Player>)null);
    }

    public void sendMessage(ChatDirection direction, Player player, String permission, String message) {
        if (player.hasPermission(permission)) {
            this.sendMessage(direction, player, message);
        }
    }

    public void sendMessage(Player player, String permission, String message) {
        this.sendMessage(ChatDirection.CHAT, player, permission, message);
    }

    public void broadcastMessage(boolean inConsole, ChatDirection direction, String message, Predicate<Player> predicate) {
        if (inConsole) {
            SERVER.getConsoleSender().sendMessage(message);
        }
        for (Player player : SERVER.getOnlinePlayers()) {
            if (predicate == null || !predicate.test(player)) continue;
            this.sendMessage(direction, player, message);
        }
    }

    public void broadcastMessage(ChatDirection direction, String message, Predicate<Player> predicate) {
        this.broadcastMessage(true, direction, message, predicate);
    }

    public void broadcastMessage(String message, Predicate<Player> predicate) {
        this.broadcastMessage(ChatDirection.CHAT, message, predicate);
    }

    public void broadcastMessage(ChatDirection direction, String message) {
        this.broadcastMessage(direction, message, (Predicate<Player>)null);
    }

    public void broadcastMessage(String message) {
        this.broadcastMessage(ChatDirection.CHAT, message);
    }

    public void broadcastMessage(ChatDirection direction, String permission, String message) {
        this.broadcastMessage(direction, message, (Player player) -> permission != null && player.hasPermission(permission));
    }

    public void broadcastMessage(String permission, String message) {
        this.broadcastMessage(ChatDirection.CHAT, permission, message);
    }
}

