/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.pxstudios.minelib.common.config.PluginConfigProvider;
import org.bukkit.plugin.Plugin;

public abstract class PluginConfig<Type> {
    private final PluginConfigProvider<Type> provider;
    private final File file;
    private Type data;

    public final Type data() {
        return this.data != null ? this.data : (this.data = this.provider.provide(this.file));
    }

    public final void set(Type value) {
        this.data = value;
    }

    public void reload() {
        this.provider.cleanUp(this.file);
        this.data = null;
    }

    public void save() {
        this.provider.save(this.file, this.data);
    }

    public void copyResource(Plugin plugin, String resourceName) {
        plugin.saveResource(resourceName, false);
    }

    public void createNewResource() {
        if (!this.isExists()) {
            Files.createFile(this.file.toPath(), new FileAttribute[0]);
        }
    }

    public boolean isExists() {
        return this.file.exists();
    }

    public PluginConfig(PluginConfigProvider<Type> provider, File file) {
        this.provider = provider;
        this.file = file;
    }
}

