/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.config.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.pxstudios.minelib.common.config.PluginConfigProvider;
import net.pxstudios.minelib.common.config.type.PropertiesPluginConfig;

public class PropertiesConfigProvider
implements PluginConfigProvider<Properties> {
    private final Map<File, Properties> typesByFileMap = new HashMap<File, Properties>();

    @Override
    public boolean validateFileFormat(File file) {
        return file != null && file.getName().endsWith(".properties");
    }

    @Override
    public Properties provide(File file) {
        Properties properties = this.typesByFileMap.get(file);
        if (properties == null) {
            properties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(file);){
                properties.load(inputStream);
            }
            this.typesByFileMap.put(file, properties);
        }
        return properties;
    }

    public PropertiesPluginConfig createConfig(File file) {
        return new PropertiesPluginConfig(this, file);
    }

    @Override
    public void save(File file, Properties properties) {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            properties.store(outputStream, "");
        }
    }

    @Override
    public void cleanUp(File file) {
        this.typesByFileMap.remove(file);
    }
}

