/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.config.provider;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.pxstudios.minelib.common.config.PluginConfigProvider;
import net.pxstudios.minelib.common.config.type.TextPluginConfig;
import org.apache.commons.io.FileUtils;

public class TextConfigProvider
implements PluginConfigProvider<String> {
    private final Map<File, String> typesByFileMap = new HashMap<File, String>();

    @Override
    public boolean validateFileFormat(File file) {
        return file != null;
    }

    @Override
    public String provide(File file) {
        String text = this.typesByFileMap.get(file);
        if (text == null) {
            text = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            this.typesByFileMap.put(file, text);
        }
        return text;
    }

    public TextPluginConfig createConfig(File file) {
        return new TextPluginConfig(this, file);
    }

    @Override
    public void save(File file, String text) {
        FileUtils.writeStringToFile((File)file, (String)text, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public void cleanUp(File file) {
        this.typesByFileMap.remove(file);
    }
}

