/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.item;

import net.pxstudios.minelib.common.item.BukkitItemModifySession;
import net.pxstudios.minelib.common.item.event.BukkitItemEventsStorage;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BukkitItem {
    private final ItemStack itemStack;
    private BukkitItemModifySession modifySession;
    private BukkitItemEventsStorage eventsStorage;

    private void addToInventory0(Inventory inventory, ItemStack itemStack) {
        inventory.addItem(new ItemStack[]{itemStack});
    }

    public final void addToInventory(Inventory inventory) {
        this.addToInventory0(inventory, this.getItem());
    }

    public final void addToPlayerInventory(Player player) {
        this.addToInventory0((Inventory)player.getInventory(), this.getModifiedItem(player));
    }

    private void setToInventory0(int slot, Inventory inventory, ItemStack itemStack) {
        inventory.setItem(slot, itemStack);
    }

    public final void setToInventory(int slot, Inventory inventory) {
        this.setToInventory0(slot, inventory, this.getItem());
    }

    public final void setToPlayerInventory(int slot, Player player) {
        this.setToInventory0(slot, (Inventory)player.getInventory(), this.getModifiedItem(player));
    }

    private void multisetToInventory0(int[] multiSlots, Inventory inventory, ItemStack itemStack) {
        for (int slot : multiSlots) {
            this.setToInventory0(slot, inventory, itemStack);
        }
    }

    public final void multisetToInventory(int[] multiSlots, Inventory inventory) {
        this.multisetToInventory0(multiSlots, inventory, this.getItem());
    }

    public final void multisetToPlayerInventory(int[] multiSlots, Player player) {
        this.multisetToInventory0(multiSlots, (Inventory)player.getInventory(), this.getModifiedItem(player));
    }

    public final Item dropNaturally(Location location) {
        return location.getWorld().dropItemNaturally(location, this.getItem());
    }

    public ItemStack getItem() {
        return this.itemStack.clone();
    }

    public ItemStack getModifiedItem(Player player) {
        ItemStack item = this.getItem();
        if (player == null || this.modifySession == null || this.modifySession.getCustomItemModifier() == null) {
            return item;
        }
        BukkitItem bukkitItem = this.modifySession.getCustomItemModifier().apply(player, new BukkitItemModifySession(new BukkitItem(item), item));
        return bukkitItem.getItem();
    }

    public final BukkitItemModifySession getModifySession() {
        return this.modifySession == null ? (this.modifySession = new BukkitItemModifySession(this, this.getItem())) : this.modifySession;
    }

    public final BukkitItemEventsStorage getEventsStorage() {
        return this.eventsStorage == null ? (this.eventsStorage = new BukkitItemEventsStorage(this)) : this.eventsStorage;
    }

    public BukkitItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

