/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.item;

import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.pxstudios.minelib.common.item.BukkitItem;
import net.pxstudios.minelib.common.item.BukkitItemFactory;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public final class BukkitItemApi {
    private static final ItemFactory ITEM_FACTORY_FROM_BUKKIT = Bukkit.getItemFactory();
    private final BukkitItemFactory factory = new BukkitItemFactory();

    public ItemStack withGlowing(ItemStack itemStack) {
        BukkitItem bukkitItem = this.factory.getByStack(itemStack).getModifySession().withEnchant(Enchantment.DURABILITY, 1).withFlag(ItemFlag.HIDE_ENCHANTS).complete();
        return bukkitItem.getItem();
    }

    public boolean equalsModifiedItems(Player player, BukkitItem firstItem, BukkitItem secondItem) {
        return this.equalsItems(firstItem.getModifiedItem(player), secondItem.getModifiedItem(player));
    }

    public boolean equalsItems(BukkitItem firstItem, BukkitItem secondItem) {
        return this.equalsItems(firstItem.getItem(), secondItem.getItem());
    }

    public boolean equalsItems(ItemStack firstItem, ItemStack secondItem) {
        return firstItem.isSimilar(secondItem);
    }

    public boolean equalsItemsWithoutAmount(ItemStack firstItem, ItemStack secondItem) {
        firstItem = firstItem.clone();
        secondItem = secondItem.clone();
        firstItem.setAmount(1);
        secondItem.setAmount(1);
        return firstItem.isSimilar(secondItem);
    }

    public boolean isMetaApplicable(ItemMeta itemMeta, Material material) {
        return ITEM_FACTORY_FROM_BUKKIT.isApplicable(itemMeta, material);
    }

    public boolean isMetaApplicable(ItemMeta itemMeta, ItemStack itemStack) {
        return ITEM_FACTORY_FROM_BUKKIT.isApplicable(itemMeta, itemStack);
    }

    public Color getDefaultLeatherColor() {
        return ITEM_FACTORY_FROM_BUKKIT.getDefaultLeatherColor();
    }

    public boolean isInventoryFull(@NonNull Inventory inventory, @NonNull Material material) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        return this.isInventoryFull(inventory, material, 1);
    }

    public boolean isInventoryFull(@NonNull Inventory inventory, @NonNull Material material, int amount) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        return this.isInventoryFull(inventory, material, amount, (short)0);
    }

    public boolean isInventoryFull(@NonNull Inventory inventory, @NonNull Material material, int amount, short damage) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        int freeItems = 0;
        for (ItemStack slot : inventory.getContents()) {
            if (slot == null) {
                freeItems += material.getMaxStackSize();
            } else {
                if (slot.getType() != material || slot.getDurability() != damage) continue;
                int i = material.getMaxStackSize() - slot.getAmount();
                if (i > 0) {
                    freeItems += i;
                }
            }
            if (freeItems < amount) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryFull(@NonNull Inventory inventory, @NonNull ItemStack item) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        int i = inventory.firstEmpty();
        if (i == -1) {
            int available = 0;
            for (ItemStack inventoryItem : inventory.getContents()) {
                if (inventoryItem == null || inventoryItem.getAmount() == inventoryItem.getMaxStackSize() || this.equalsItemsWithoutAmount(inventoryItem, item) || (available += inventoryItem.getMaxStackSize() - inventoryItem.getAmount()) < item.getAmount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isInventoryFull(@NonNull Player player, @NonNull ItemStack item) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return this.isInventoryFull((Inventory)player.getInventory(), item);
    }

    public int search(@NonNull Inventory inventory, @NonNull Material material) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        int items = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() != material) continue;
            items += item.getAmount();
        }
        return items;
    }

    public int fastSearch(@NonNull Player player, @NonNull Material material) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        return this.search((Inventory)player.getInventory(), material);
    }

    public void depositItem(@NonNull Inventory inventory, @NonNull Material material) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        this.depositItem(inventory, material, 1);
    }

    public void depositItem(@NonNull Inventory inventory, @NonNull Material material, int amount) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        this.depositItem(inventory, material, amount, (short)0);
    }

    public void depositItem(@NonNull Inventory inventory, @NonNull Material material, int amount, short damage) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        if (amount <= 0) {
            return;
        }
        int i = 0;
        ItemStack[] items = new ItemStack[(int)Math.ceil((double)amount / (double)material.getMaxStackSize())];
        while (amount > 0) {
            items[i++] = new ItemStack(material, amount, damage);
            amount -= material.getMaxStackSize();
        }
        inventory.addItem(items);
    }

    public boolean hasInventoryItem(@NonNull Inventory inventory, @NonNull Material material, int amount, short damage) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        if (amount <= 0) {
            return true;
        }
        int found = 0;
        for (ItemStack slot : inventory.getContents()) {
            if (slot == null || slot.getType() != material || slot.getDurability() != damage || (found += slot.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    public boolean hasInventoryItem(@NonNull Inventory inventory, @NonNull Material material, int amount) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        return this.hasInventoryItem(inventory, material, amount, (short)0);
    }

    public boolean hasInventoryItem(@NonNull Inventory inventory, @NonNull Material material) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        return this.hasInventoryItem(inventory, material, 1);
    }

    public boolean hasInventoryItem(@NonNull Inventory inventory, @NonNull ItemStack item) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return this.hasInventoryItem(inventory, item, item.getAmount());
    }

    public boolean hasInventoryItem(@NonNull Inventory inventory, @NonNull ItemStack item, int amount) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        int found = 0;
        for (ItemStack slot : inventory.getContents()) {
            if (slot == null || !this.equalsItemsWithoutAmount(item, slot) || (found += slot.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    public int packSearch(@NonNull Player player, @NonNull ItemStack targetItem) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (targetItem == null) {
            throw new NullPointerException("targetItem is marked non-null but is null");
        }
        return (int)Math.floor((double)this.search(player, targetItem) / (double)targetItem.getAmount());
    }

    public int search(@NonNull Player player, @NonNull ItemStack targetItem) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (targetItem == null) {
            throw new NullPointerException("targetItem is marked non-null but is null");
        }
        int items = 0;
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (item == null || !this.equalsItemsWithoutAmount(item, targetItem)) continue;
            items += item.getAmount();
        }
        return items;
    }

    public void withdraw(@NonNull Inventory inventory, @NonNull ItemStack targetItem, int amount) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (targetItem == null) {
            throw new NullPointerException("targetItem is marked non-null but is null");
        }
        ItemStack[] items = inventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null || !this.equalsItemsWithoutAmount(targetItem, item)) continue;
            if (item.getAmount() <= amount) {
                items[i] = null;
                amount -= item.getAmount();
            } else {
                item.setAmount(item.getAmount() - amount);
                amount = 0;
            }
            if (amount <= 0) break;
        }
        inventory.setContents(items);
    }

    public void fastWithdraw(@NonNull Inventory inventory, @NonNull Material type) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.fastWithdraw(inventory, type, 1);
    }

    public void fastWithdraw(@NonNull Inventory inventory, @NonNull Material type, int amount) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.withdrawItem(inventory, type, amount, (short)0);
    }

    public void withdrawItem(@NonNull Inventory inventory, @NonNull Material type, int amount, short damage) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (amount <= 0) {
            return;
        }
        ItemStack[] items = inventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null || type != item.getType() || damage != item.getDurability()) continue;
            if (item.getAmount() <= amount) {
                items[i] = null;
                amount -= item.getAmount();
            } else {
                item.setAmount(item.getAmount() - amount);
                amount = 0;
            }
            if (amount <= 0) break;
        }
        inventory.setContents(items);
    }

    public void fastWithdraw(@NonNull Inventory inventory, @NonNull Material type, int amount, short damage) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.withdrawItem(inventory, type, amount, damage);
    }

    public ItemStack parseItem(ConfigurationSection section) {
        ConfigurationSection enchants;
        String id = section.getString("id", "");
        Material type = Material.matchMaterial((String)Objects.requireNonNull(id));
        if (type == null) {
            System.out.println("Material \"" + id + "\" not found at " + section.getCurrentPath());
            type = Material.STONE;
        }
        ItemStack itemStack = new ItemStack(type, section.getInt("amount", 1), (short)section.getInt("durability", 0));
        ItemMeta itemMeta = itemStack.getItemMeta();
        String displayName = section.getString("name");
        List lore = section.getStringList("lore");
        if (displayName != null) {
            itemMeta.setDisplayName(displayName);
        }
        if (lore != null) {
            itemMeta.setLore(lore);
        }
        if ((enchants = section.getConfigurationSection("enchants")) != null) {
            for (String enchantment : enchants.getKeys(false)) {
                Enchantment bukkitEnchantment = Enchantment.getByName((String)enchantment.toUpperCase());
                if (bukkitEnchantment == null) continue;
                int level = enchants.getInt(enchantment);
                if (itemMeta instanceof EnchantmentStorageMeta) {
                    EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
                    enchantmentStorageMeta.addStoredEnchant(bukkitEnchantment, level, true);
                    continue;
                }
                itemMeta.addEnchant(bukkitEnchantment, level, true);
            }
        }
        for (Object flagName : section.getStringList("flags")) {
            ItemFlag itemFlag = ItemFlag.valueOf((String)((String)flagName).toUpperCase());
            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        if (itemMeta instanceof PotionMeta) {
            ConfigurationSection baseEffectSection;
            ConfigurationSection potionSection = section.getConfigurationSection("effects");
            if (potionSection != null) {
                for (String effect : potionSection.getKeys(false)) {
                    PotionEffectType effectType = PotionEffectType.getByName((String)effect);
                    if (effectType == null) continue;
                    int duration = potionSection.getInt(effect.concat(".duration"), 0) * 20;
                    int amplifier = potionSection.getInt(effect.concat(".amplifier"), 0);
                    boolean ambient = potionSection.getBoolean(effect.concat(".ambient"));
                    boolean particles = potionSection.getBoolean(effect.concat(".particles"), true);
                    PotionEffect potionEffect = new PotionEffect(effectType, duration, amplifier, ambient, particles);
                    ((PotionMeta)itemMeta).addCustomEffect(potionEffect, true);
                }
            }
            if ((baseEffectSection = section.getConfigurationSection("base_effect")) != null) {
                String effectType = baseEffectSection.getString("type");
                boolean upgraded = baseEffectSection.getBoolean("upgraded", false);
                boolean extended = baseEffectSection.getBoolean("extended", false);
                boolean splash = baseEffectSection.getBoolean("splash", false);
                Potion potion = new Potion(PotionType.valueOf((String)effectType));
                if (extended) {
                    potion.setHasExtendedDuration(true);
                }
                potion.setLevel(upgraded ? 2 : 1);
                potion.setSplash(splash);
                ItemStack potionStack = potion.toItemStack(1);
                PotionMeta meta = (PotionMeta)potionStack.getItemMeta();
                itemStack.setDurability(potionStack.getDurability());
                ((PotionMeta)itemMeta).setMainEffect(potion.getType().getEffectType());
                for (PotionEffect effect : meta.getCustomEffects()) {
                    ((PotionMeta)itemMeta).addCustomEffect(effect, true);
                }
            }
        }
        if (section.contains("color")) {
            Color color = this.getColor(section);
            if (itemMeta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)itemMeta).setColor(color);
            }
        }
        itemStack.setItemMeta(itemMeta);
        if (section.contains("monsterType")) {
            EntityType monsterType = EntityType.valueOf((String)section.getString("monsterType"));
            itemStack.setDurability(monsterType.getTypeId());
        }
        return itemStack;
    }

    public Color getColor(ConfigurationSection section) {
        return Color.fromRGB((int)(section.getInt("potionColor") & 0xFFFFFF));
    }

    public BukkitItemFactory getFactory() {
        return this.factory;
    }
}

