/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.location.point;

import net.pxstudios.minelib.common.location.point.Point3D;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class Point2D {
    private double x;
    private double y;

    public Point2D(Location location) {
        this(location.getX(), location.getY());
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public Point2D x(double x) {
        this.x = x;
        return this;
    }

    public Point2D y(double y) {
        this.y = y;
        return this;
    }

    public Point2D set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point2D add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Point2D subtract(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Point2D divide(double x, double y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Point2D multiply(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Point2D zero() {
        return this.set(0.0, 0.0);
    }

    public Point3D to3D(double z) {
        return new Point3D(this.x, this.y, z);
    }

    public Point3D to3D() {
        return this.to3D(0.0);
    }

    public Vector toVector(double z) {
        return new Vector(this.x, this.y, z);
    }

    public Vector toVector() {
        return this.toVector(0.0);
    }

    public final Point2D clone() {
        return new Point2D(this.x, this.y);
    }

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }
}

