/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.common.location.point;

import net.pxstudios.minelib.common.location.point.Point2D;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class Point3D {
    private double x;
    private double y;
    private double z;

    public Point3D(Location location) {
        this(location.getX(), location.getY(), location.getZ());
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Point3D x(double x) {
        this.x = x;
        return this;
    }

    public Point3D y(double y) {
        this.y = y;
        return this;
    }

    public Point3D z(double z) {
        this.z = z;
        return this;
    }

    public Point3D set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Point3D add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Point3D subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Point3D divide(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Point3D multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Point3D zero() {
        return this.set(0.0, 0.0, 0.0);
    }

    public Point2D to2D() {
        return new Point2D(this.x, this.y);
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public final Point3D clone() {
        return new Point3D(this.x, this.y, this.z);
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

