/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.cooldown;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.pxstudios.minelib.beat.wrapper.WrapperBukkitTask;
import net.pxstudios.minelib.cooldown.CooldownFlag;
import net.pxstudios.minelib.cooldown.CooldownLeftReason;
import net.pxstudios.minelib.cooldown.PlayerCooldownApi;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.entity.Player;

public final class Cooldown {
    private final String name;
    private final long initMillisecondsTime;
    private final long millisecondsDelay;
    private final Set<CooldownFlag> flagsSet = new HashSet<CooldownFlag>();
    private Player player;
    private CompletableFuture<CooldownLeftReason> onLeft;
    private WrapperBukkitTask automaticallyExpirationTask;

    public static Cooldown byMilliseconds(String name, long millisecondsDelay) {
        return new Cooldown(name, System.currentTimeMillis(), millisecondsDelay);
    }

    public static Cooldown bySeconds(String name, long secondsDelay) {
        return Cooldown.byMilliseconds(name, TimeUnit.SECONDS.toMillis(secondsDelay));
    }

    public static Cooldown byTicks(String name, long bukkitTicksDelay) {
        return Cooldown.byMilliseconds(name, bukkitTicksDelay * 50L);
    }

    public Cooldown withFlag(@NonNull CooldownFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        this.flagsSet.add(flag);
        return this;
    }

    boolean hasFlag(CooldownFlag flag) {
        return this.flagsSet.contains((Object)flag);
    }

    boolean isExpired() {
        return System.currentTimeMillis() - this.initMillisecondsTime >= this.millisecondsDelay;
    }

    void enableAutoExpirationTask(MinecraftPlugin plugin) {
        long delayAsTicks = this.millisecondsDelay / 50L;
        this.automaticallyExpirationTask = plugin.getMineLibrary().getBeater().runLater(delayAsTicks, () -> this.left(CooldownLeftReason.TIME_EXPIRED));
    }

    void left(CooldownLeftReason leftReason) {
        if (this.automaticallyExpirationTask != null) {
            this.automaticallyExpirationTask.cancel();
        }
        if (this.onLeft != null) {
            this.onLeft.complete(leftReason);
        }
        if (this.player != null) {
            PlayerCooldownApi.cooldownsMultimap.remove((Object)this.player, (Object)this);
        }
    }

    String getName() {
        return this.name;
    }

    long getInitMillisecondsTime() {
        return this.initMillisecondsTime;
    }

    long getMillisecondsDelay() {
        return this.millisecondsDelay;
    }

    Set<CooldownFlag> getFlagsSet() {
        return this.flagsSet;
    }

    Player getPlayer() {
        return this.player;
    }

    CompletableFuture<CooldownLeftReason> getOnLeft() {
        return this.onLeft;
    }

    WrapperBukkitTask getAutomaticallyExpirationTask() {
        return this.automaticallyExpirationTask;
    }

    private Cooldown(String name, long initMillisecondsTime, long millisecondsDelay) {
        this.name = name;
        this.initMillisecondsTime = initMillisecondsTime;
        this.millisecondsDelay = millisecondsDelay;
    }

    void setPlayer(Player player) {
        this.player = player;
    }

    void setOnLeft(CompletableFuture<CooldownLeftReason> onLeft) {
        this.onLeft = onLeft;
    }
}

