/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.event.bukkit;

import net.pxstudios.minelib.MineLibrary;
import net.pxstudios.minelib.event.bukkit.inventory.MLInventoryClickEvent;
import net.pxstudios.minelib.event.bukkit.inventory.MLInventoryCloseEvent;
import net.pxstudios.minelib.event.bukkit.player.MLPlayerDamageEvent;
import net.pxstudios.minelib.event.bukkit.player.MLPlayerProjectileHitEvent;
import net.pxstudios.minelib.event.bukkit.player.MLPlayerProjectileLaunchEvent;
import net.pxstudios.minelib.event.bukkit.player.MLPlayerShootBowEvent;
import net.pxstudios.minelib.event.player.MLPlayerKillEvent;
import net.pxstudios.minelib.gui.GuiSlot;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.projectiles.ProjectileSource;

public final class BukkitEventsWrapperListener
implements Listener {
    private final MineLibrary mineLibrary;

    public MLInventoryClickEvent callInventoryClickEvent(InventoryClickEvent event) {
        MLInventoryClickEvent wrapperEvent = new MLInventoryClickEvent(this.mineLibrary, event.getClickedInventory(), (Player)event.getWhoClicked(), event.getClick(), event.getAction(), event.getSlotType(), event.getCurrentItem(), GuiSlot.byArray(event.getSlot()), event.getRawSlot(), event.getHotbarButton());
        this.mineLibrary.getEventsSubscriber().callEvent(wrapperEvent);
        return wrapperEvent;
    }

    public MLPlayerDamageEvent callPlayerDamageEvent(EntityDamageEvent event) {
        MLPlayerDamageEvent wrapperEvent = new MLPlayerDamageEvent(this.mineLibrary, (Player)event.getEntity(), event.getCause(), event.getDamage());
        this.mineLibrary.getEventsSubscriber().callEvent(wrapperEvent);
        return wrapperEvent;
    }

    public MLPlayerShootBowEvent callPlayerShootBowEvent(EntityShootBowEvent event) {
        MLPlayerShootBowEvent wrapperEvent = new MLPlayerShootBowEvent(this.mineLibrary, (Player)event.getEntity(), event.getBow(), event.getProjectile(), event.getForce());
        this.mineLibrary.getEventsSubscriber().callEvent(wrapperEvent);
        return wrapperEvent;
    }

    public void callInventoryCloseEvent(InventoryCloseEvent event) {
        this.mineLibrary.getEventsSubscriber().callEvent(new MLInventoryCloseEvent(this.mineLibrary, event.getInventory(), (Player)event.getPlayer()));
    }

    public void callPlayerProjectileHitEvent(ProjectileHitEvent event) {
        this.mineLibrary.getEventsSubscriber().callEvent(new MLPlayerProjectileHitEvent(this.mineLibrary, (Player)event.getEntity(), event.getEntity(), event.getHitEntity(), event.getHitBlock()));
    }

    public void callPlayerProjectileLaunchEvent(ProjectileLaunchEvent event) {
        this.mineLibrary.getEventsSubscriber().callEvent(new MLPlayerProjectileLaunchEvent(this.mineLibrary, (Player)event.getEntity(), event.getEntity()));
    }

    public void callPlayerKillEvent(PlayerDeathEvent event) {
        this.mineLibrary.getEventsSubscriber().callEvent(new MLPlayerKillEvent(this.mineLibrary, event.getEntity(), event.getEntity().getKiller()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(InventoryClickEvent event) {
        HumanEntity entity = event.getWhoClicked();
        if (entity.getType() == EntityType.PLAYER) {
            event.setCancelled(this.callInventoryClickEvent(event).isCancelled());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            event.setCancelled(this.callPlayerDamageEvent(event).isCancelled());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(EntityShootBowEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            event.setCancelled(this.callPlayerShootBowEvent(event).isCancelled());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(InventoryCloseEvent event) {
        HumanEntity entity = event.getPlayer();
        if (entity.getType() == EntityType.PLAYER) {
            this.callInventoryCloseEvent(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(ProjectileHitEvent event) {
        ProjectileSource entity = event.getEntity().getShooter();
        if (entity instanceof Player) {
            this.callPlayerProjectileHitEvent(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(ProjectileLaunchEvent event) {
        ProjectileSource entity = event.getEntity().getShooter();
        if (entity instanceof Player) {
            this.callPlayerProjectileLaunchEvent(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void handle(PlayerDeathEvent event) {
        if (event.getEntity().getKiller() != null) {
            this.callPlayerKillEvent(event);
        }
    }

    public BukkitEventsWrapperListener(MineLibrary mineLibrary) {
        this.mineLibrary = mineLibrary;
    }
}

