/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.fastutil.blockplace;

import lombok.NonNull;
import net.pxstudios.minelib.nms.NmsHelper;
import net.pxstudios.minelib.nms.WrapperNmsChunk;
import net.pxstudios.minelib.nms.WrapperNmsWorld;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class FastBlockPlaceSession {
    private final WrapperNmsWorld wrapperNmsWorld;
    private Long startTimeMillis;

    public FastBlockPlaceSession(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.wrapperNmsWorld = NmsHelper.wrap(world);
    }

    public FastBlockPlaceSession setBlockData(@NonNull Block block, @NonNull MaterialData materialData) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (materialData == null) {
            throw new NullPointerException("materialData is marked non-null but is null");
        }
        if (this.startTimeMillis == null) {
            this.startTimeMillis = System.currentTimeMillis();
        }
        if (block.getY() > block.getWorld().getMaxHeight()) {
            return this;
        }
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        WrapperNmsChunk nmsChunk = this.wrapperNmsWorld.getNmsChunkAt(x, z);
        nmsChunk.setFastBlock(this.wrapperNmsWorld.getChunksFlag(), x, y, z, materialData);
        return this;
    }

    public FastBlockPlaceSession setBlockData(@NonNull Location location, @NonNull MaterialData materialData) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (materialData == null) {
            throw new NullPointerException("materialData is marked non-null but is null");
        }
        if (this.startTimeMillis == null) {
            this.startTimeMillis = System.currentTimeMillis();
        }
        if (location.getBlockY() > location.getWorld().getMaxHeight()) {
            return this;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WrapperNmsChunk nmsChunk = this.wrapperNmsWorld.getNmsChunkAt(x, z);
        nmsChunk.setFastBlock(this.wrapperNmsWorld.getChunksFlag(), x, y, z, materialData);
        return this;
    }

    public FastBlockPlaceSession setBlockData(@NonNull World world, @NonNull Vector vector, @NonNull MaterialData materialData) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        if (materialData == null) {
            throw new NullPointerException("materialData is marked non-null but is null");
        }
        return this.setBlockData(vector.toLocation(world), materialData);
    }

    public FastBlockPlaceSession setBlockType(@NonNull Block block, @NonNull Material type) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.setBlockData(block, new MaterialData(type));
    }

    public FastBlockPlaceSession setBlockType(@NonNull Location location, @NonNull Material type) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.setBlockData(location, new MaterialData(type));
    }

    public FastBlockPlaceSession setBlockType(@NonNull World world, @NonNull Vector vector, @NonNull Material type) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.setBlockType(vector.toLocation(world), type);
    }

    public FastBlockPlaceSession setBlockTypeAndData(@NonNull Block block, @NonNull Material type, int data) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.setBlockData(block, new MaterialData(type, (byte)data));
    }

    public FastBlockPlaceSession setBlockTypeAndData(@NonNull Location location, @NonNull Material type, int data) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.setBlockData(location, new MaterialData(type, (byte)data));
    }

    public FastBlockPlaceSession setBlockTypeAndData(@NonNull World world, @NonNull Vector vector, @NonNull Material type, int data) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.setBlockTypeAndData(vector.toLocation(world), type, data);
    }

    public FastBlockPlaceSession setBlockTypeIdAndData(@NonNull Block block, int id, int data) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        return this.setBlockData(block, new MaterialData(id, (byte)data));
    }

    public FastBlockPlaceSession setBlockTypeIdAndData(@NonNull Location location, int id, int data) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.setBlockData(location, new MaterialData(id, (byte)data));
    }

    public FastBlockPlaceSession setBlockTypeIdAndData(@NonNull World world, @NonNull Vector vector, int id, int data) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        return this.setBlockTypeIdAndData(vector.toLocation(world), id, data);
    }

    public long flush() {
        this.wrapperNmsWorld.flush();
        System.gc();
        return this.startTimeMillis > 0L ? System.currentTimeMillis() - this.startTimeMillis : -1L;
    }
}

