/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.gui;

import net.pxstudios.minelib.common.location.point.Point2D;

public class GuiSlot {
    private int slot;
    private Point2D point2D;

    public static Point2D toMatrix2D(int slot) {
        int y = slot / 9;
        int x = slot - y * 9;
        return new Point2D(x, y);
    }

    public static int toIntSlot(int x, int y) {
        return (y + 1) * 9 - (9 - x);
    }

    public static GuiSlot byArray(int slot) {
        return new GuiSlot(slot, GuiSlot.toMatrix2D(slot));
    }

    public static GuiSlot first() {
        return GuiSlot.byArray(0);
    }

    public static GuiSlot bySlot(int slot) {
        return GuiSlot.byArray(slot - 1);
    }

    public static GuiSlot byMatrixArray(int x, int y) {
        return new GuiSlot(GuiSlot.toIntSlot(x, y) - 1, new Point2D(x, y));
    }

    public static GuiSlot byMatrix(int x, int y) {
        return GuiSlot.byMatrixArray(x - 1, y - 1);
    }

    public final int toSlotIndex() {
        return this.slot;
    }

    public final int toMatrixX() {
        return (int)this.point2D.x();
    }

    public final int toMatrixY() {
        return (int)this.point2D.y();
    }

    public final Point2D toPoint2D() {
        return this.point2D;
    }

    public final GuiSlot normalize() {
        return new GuiSlot(this.slot + 1, this.point2D.clone().add(1.0, 1.0));
    }

    public final GuiSlot right(int count) {
        this.slot += count;
        this.point2D = GuiSlot.toMatrix2D(this.slot);
        return this;
    }

    public final GuiSlot left(int count) {
        int newValue = this.slot - count;
        if (newValue < 0) {
            throw new IllegalArgumentException("GuiSlot value cannot be < 0");
        }
        this.slot = newValue;
        this.point2D = GuiSlot.toMatrix2D(newValue);
        return this;
    }

    public final GuiSlot up(int count) {
        return this.left(count * 9);
    }

    public final GuiSlot down(int count) {
        return this.right(count * 9);
    }

    public final GuiSlot clone() {
        return new GuiSlot(this.slot, this.point2D);
    }

    private GuiSlot(int slot, Point2D point2D) {
        this.slot = slot;
        this.point2D = point2D;
    }
}

