/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.gui.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.pxstudios.minelib.common.item.BukkitItem;
import net.pxstudios.minelib.common.item.BukkitItemModifySession;
import net.pxstudios.minelib.event.bukkit.inventory.MLInventoryClickEvent;
import net.pxstudios.minelib.gui.Gui;
import net.pxstudios.minelib.gui.GuiItem;
import net.pxstudios.minelib.gui.GuiSlot;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class GuiProvider {
    private final InventoryType inventoryType;
    private String title;
    private int size;
    private Gui gui;
    private MinecraftPlugin plugin;

    protected static int toSize(int rows) {
        return rows * 9;
    }

    protected static GuiSlot toSlot(int slot) {
        return GuiSlot.bySlot(slot);
    }

    protected static GuiSlot toSlot(int x, int y) {
        return GuiSlot.byMatrix(x, y);
    }

    protected static BukkitItemModifySession toItem(ItemStack itemStack) {
        return new BukkitItem(itemStack).getModifySession();
    }

    protected static BukkitItemModifySession toItem(MaterialData materialData) {
        return GuiProvider.toItem(materialData.toItemStack(1));
    }

    protected static BukkitItemModifySession toItem(Material material) {
        return GuiProvider.toItem(new MaterialData(material));
    }

    public GuiProvider(InventoryType inventoryType, String title, int size) {
        this.inventoryType = inventoryType;
        this.title = title;
        this.size = size;
    }

    public GuiProvider(String title, int size) {
        this(InventoryType.CHEST, title, size);
    }

    public GuiProvider(int size) {
        this("", size);
    }

    public GuiProvider(String title) {
        this(title, 27);
    }

    public abstract void draw(Player var1, DrawingSession var2);

    public void onOpen(Player player, Inventory bukkit) {
    }

    public void onClosed(Player player, Inventory bukkit) {
    }

    public DrawingSession createDrawingSession() {
        return new DrawingSession();
    }

    public final void update(Player player) {
        if (this.gui != null) {
            this.gui.updateGui(player);
        }
    }

    public final void updateAutomatically(int ticks, final Player player) {
        this.plugin.getMineLibrary().getBeater().runCancellableTimer(ticks, new BukkitRunnable(){

            public void run() {
                if (player.isOnline() && GuiProvider.this.gui.isOpened(player)) {
                    GuiProvider.this.update(player);
                } else {
                    this.cancel();
                }
            }
        });
    }

    public void setup(Inventory bukkit, DrawingSession session) {
        bukkit.clear();
        for (GuiItem item : session.getItems()) {
            bukkit.setItem(item.getSlot().toSlotIndex(), item.getItemStack());
        }
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    public Gui getGui() {
        return this.gui;
    }

    public void setGui(Gui gui) {
        this.gui = gui;
    }

    public MinecraftPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public static class DrawingSession {
        protected final Map<GuiSlot, GuiItem> itemsBySlotsMap = new HashMap<GuiSlot, GuiItem>();

        public void add(GuiItem guiItem) {
            this.itemsBySlotsMap.put(guiItem.getSlot(), guiItem);
        }

        public void add(GuiSlot guiSlot, ItemStack itemStack, Consumer<MLInventoryClickEvent> eventHandler) {
            this.add(new GuiItem(guiSlot, itemStack, eventHandler));
        }

        public void add(GuiSlot guiSlot, BukkitItem bukkitItem, Consumer<MLInventoryClickEvent> eventHandler) {
            this.add(new GuiItem(guiSlot, bukkitItem.getItem(), eventHandler));
        }

        public void add(GuiSlot guiSlot, Player player, BukkitItem bukkitItem, Consumer<MLInventoryClickEvent> eventHandler) {
            this.add(new GuiItem(guiSlot, bukkitItem.getModifiedItem(player), eventHandler));
        }

        public void add(GuiSlot guiSlot, ItemStack itemStack) {
            this.add(guiSlot, itemStack, null);
        }

        public void add(GuiSlot guiSlot, BukkitItem bukkitItem) {
            this.add(guiSlot, bukkitItem.getItem());
        }

        public void add(GuiSlot guiSlot, Player player, BukkitItem bukkitItem) {
            this.add(guiSlot, bukkitItem.getModifiedItem(player));
        }

        public final GuiItem getItem(GuiSlot slot) {
            return this.itemsBySlotsMap.get(slot);
        }

        public final Collection<GuiItem> getItems() {
            return Collections.unmodifiableCollection(this.itemsBySlotsMap.values());
        }

        protected DrawingSession() {
        }
    }
}

