/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.gui.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.pxstudios.minelib.common.item.BukkitItem;
import net.pxstudios.minelib.event.bukkit.inventory.MLInventoryClickEvent;
import net.pxstudios.minelib.gui.GuiItem;
import net.pxstudios.minelib.gui.provider.GuiProvider;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public abstract class MatrixGuiProvider
extends GuiProvider {
    private char[][] matrix;

    public MatrixGuiProvider(InventoryType inventoryType, String name) {
        super(inventoryType, name, 0);
    }

    public MatrixGuiProvider(String name) {
        this(InventoryType.CHEST, name);
    }

    public MatrixGuiProvider(InventoryType inventoryType) {
        this(inventoryType, "");
    }

    public MatrixGuiProvider() {
        this(InventoryType.CHEST);
    }

    public void setMatrix(char[][] matrix) {
        this.matrix = matrix;
        this.setSize(matrix.length * matrix[0].length);
    }

    public abstract void draw(Player var1, MatrixDrawingSession var2);

    @Override
    public MatrixDrawingSession createDrawingSession() {
        return new MatrixDrawingSession();
    }

    @Override
    public void draw(Player player, GuiProvider.DrawingSession drawingSession) {
        int x = 0;
        int y = 0;
        MatrixDrawingSession matrixDrawingSession = (MatrixDrawingSession)drawingSession;
        for (char[] row : this.matrix) {
            ++y;
            for (char sign : row) {
                ++x;
                GuiItem guiItem = matrixDrawingSession.getItemBySign(sign);
                if (guiItem == null) continue;
                guiItem.setSlot(MatrixGuiProvider.toSlot(x, y));
                drawingSession.add(guiItem);
            }
        }
    }

    public char[][] getMatrix() {
        return this.matrix;
    }

    public static class MatrixDrawingSession
    extends GuiProvider.DrawingSession {
        private final Map<Character, GuiItem> matrixItemsMap = new HashMap<Character, GuiItem>();

        public void add(char sign, GuiItem guiItem) {
            this.matrixItemsMap.put(Character.valueOf(sign), guiItem);
        }

        public void add(char sign, ItemStack itemStack, Consumer<MLInventoryClickEvent> eventHandler) {
            this.add(sign, new GuiItem(null, itemStack, eventHandler));
        }

        public void add(char sign, BukkitItem bukkitItem, Consumer<MLInventoryClickEvent> eventHandler) {
            this.add(sign, bukkitItem.getItem(), eventHandler);
        }

        public void add(char sign, Player player, BukkitItem bukkitItem, Consumer<MLInventoryClickEvent> eventHandler) {
            this.add(sign, bukkitItem.getModifiedItem(player), eventHandler);
        }

        public void add(char sign, ItemStack itemStack) {
            this.add(sign, itemStack, null);
        }

        public void add(char sign, BukkitItem bukkitItem) {
            this.add(sign, bukkitItem, null);
        }

        public void add(char sign, Player player, BukkitItem bukkitItem) {
            this.add(sign, player, bukkitItem, null);
        }

        public final GuiItem getItemBySign(char sign) {
            return this.matrixItemsMap.get(Character.valueOf(sign));
        }

        public final Collection<GuiItem> getSignedItems() {
            return Collections.unmodifiableCollection(this.matrixItemsMap.values());
        }

        protected MatrixDrawingSession() {
        }
    }
}

