/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.nms;

import java.util.Arrays;
import lombok.NonNull;
import net.pxstudios.minelib.nms.NmsHelper;
import net.pxstudios.minelib.nms.NmsWrapper;
import net.pxstudios.minelib.nms.WrapperNmsBlockData;
import org.bukkit.Chunk;
import org.bukkit.material.MaterialData;

public class WrapperNmsChunk
implements NmsWrapper {
    private final Object handle;
    private Object[] chunkSectionsArray;

    WrapperNmsChunk(@NonNull Object handle) {
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        this.handle = handle;
    }

    public WrapperNmsChunk(@NonNull Chunk chunk) {
        this(NmsHelper.getNmsHandle(chunk));
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
    }

    private Object findChunkSection(boolean chunksFlag, int y) {
        if (this.chunkSectionsArray == null) {
            this.chunkSectionsArray = NmsHelper.METHOD_GET_CHUNK_SECTIONS.invoke(this.handle);
        }
        int sectionIndex = y >> 4;
        Object section = null;
        if (sectionIndex < this.chunkSectionsArray.length) {
            section = this.chunkSectionsArray[sectionIndex];
        } else {
            int add = this.chunkSectionsArray.length == sectionIndex ? 1 : sectionIndex - this.chunkSectionsArray.length;
            this.chunkSectionsArray = Arrays.copyOf(this.chunkSectionsArray, this.chunkSectionsArray.length + add);
        }
        if (section == null) {
            this.chunkSectionsArray[sectionIndex] = section = NmsHelper.CONSTRUCTOR_CHUCK_SECTION.invoke(y >> 4 << 4, chunksFlag);
        }
        return section;
    }

    public void setFastBlock(boolean chunksFlag, int x, int y, int z, @NonNull MaterialData materialData) {
        if (materialData == null) {
            throw new NullPointerException("materialData is marked non-null but is null");
        }
        WrapperNmsBlockData blockData = NmsHelper.wrap(materialData);
        Object section = this.findChunkSection(chunksFlag, y);
        NmsHelper.invokeSetFastBlock(section, x & 0xF, y & 0xF, z & 0xF, blockData.getHandle());
    }

    public void flush() {
        this.chunkSectionsArray = null;
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }

    public Object[] getChunkSectionsArray() {
        return this.chunkSectionsArray;
    }
}

