/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.nms;

import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import net.pxstudios.minelib.nms.NmsHelper;
import net.pxstudios.minelib.nms.NmsWrapper;
import net.pxstudios.minelib.nms.WrapperNmsChunk;
import org.bukkit.World;

public class WrapperNmsWorld
implements NmsWrapper {
    private final Map<Integer, WrapperNmsChunk> chunksMap = new ConcurrentHashMap<Integer, WrapperNmsChunk>();
    private final Object handle;
    private Boolean chunksFlag;

    WrapperNmsWorld(@NonNull Object handle) {
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        this.handle = handle;
    }

    public WrapperNmsWorld(@NonNull World world) {
        this(NmsHelper.getNmsHandle(world));
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
    }

    public WrapperNmsChunk getNmsChunkAt(int x, int z) {
        int chX = x >> 4;
        int chZ = z >> 4;
        return this.chunksMap.computeIfAbsent(chX + chZ, sum -> new WrapperNmsChunk(NmsHelper.getNmsChunkAt(this.handle, chX, chZ)));
    }

    public void refreshChunkAt(int x, int z) {
        int chX = x >> 4;
        int chZ = z >> 4;
        Object nmsPlayerChunkMap = NmsHelper.LOOKUP.findVirtual(NmsHelper.WORLD_SERVER_CLASS, "getPlayerChunkMap", MethodType.methodType(NmsHelper.PLAYER_CHUNK_MAP_CLASS)).invoke(this.handle);
        NmsHelper.LOOKUP.findVirtual(NmsHelper.PLAYER_CHUNK_MAP_CLASS, "a", MethodType.methodType(Boolean.TYPE, Integer.TYPE, Integer.TYPE)).invoke(nmsPlayerChunkMap, chX, chZ);
    }

    public boolean getChunksFlag() {
        if (this.chunksFlag == null) {
            this.chunksFlag = NmsHelper.LOOKUP.findVirtual(NmsHelper.WORLD_PROVIDER_CLASS, "m", MethodType.methodType(Boolean.TYPE)).invoke(NmsHelper.LOOKUP.findGetter(NmsHelper.WORLD_SERVER_CLASS, "worldProvider", NmsHelper.WORLD_PROVIDER_CLASS).invoke(this.handle));
        }
        return this.chunksFlag;
    }

    public void flush() {
        this.chunksMap.forEach((integer, wrapperNmsChunk) -> wrapperNmsChunk.flush());
        this.chunksMap.clear();
    }

    public Map<Integer, WrapperNmsChunk> getChunksMap() {
        return this.chunksMap;
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }
}

