/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.pxstudios.minelib.permission.PlayerPermissionApi;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.ServerOperator;

public class BukkitPermissibleObjectProvider
extends PermissibleBase {
    private final PlayerPermissionApi permissionApi;
    private final Player player;
    private final Set<String> permissionsSet = new HashSet<String>();

    BukkitPermissibleObjectProvider(PlayerPermissionApi permissionApi, Player player) {
        super((ServerOperator)player);
        this.permissionApi = permissionApi;
        this.player = player;
        if (permissionApi.getPermissionDatabaseProvider() != null) {
            this.applyPermissions(permissionApi.getPermissionDatabaseProvider().providePermissions(player));
        }
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissionsSet);
    }

    public void addPermission(String permission) {
        if (this.permissionsSet.add(permission) && this.permissionApi.getPermissionDatabaseProvider() != null) {
            this.permissionApi.getPermissionDatabaseProvider().onPermissionAdd(this.player, permission);
        }
    }

    public void removePermission(String permission) {
        if (this.permissionsSet.remove(permission) && this.permissionApi.getPermissionDatabaseProvider() != null) {
            this.permissionApi.getPermissionDatabaseProvider().onPermissionDelete(this.player, permission);
        }
    }

    public void clearPermissions() {
        this.permissionsSet.clear();
    }

    public void applyPermissions(Collection<String> permissions) {
        if (permissions != null) {
            this.permissionsSet.addAll(permissions);
        }
    }

    public boolean hasOwnPermission() {
        return this.permissionsSet.contains("*");
    }

    private boolean calculateAndApplyPermission(String permission) {
        String[] parts = permission.split("\\.");
        StringBuilder partsBuilder = new StringBuilder();
        for (int in = 0; in < parts.length; ++in) {
            partsBuilder.append(parts[0]).append(".");
            if (!this.permissionsSet.contains(partsBuilder + "*")) continue;
            return true;
        }
        return false;
    }

    public boolean isOp() {
        return this.permissionApi.isEnabledOperatorsSystem() && super.isOp();
    }

    public boolean hasPermission(Permission perm) {
        return this.hasPermission(perm.getName());
    }

    public boolean hasPermission(String permission) {
        if (this.hasOwnPermission() || this.permissionsSet.contains(permission)) {
            return true;
        }
        return this.calculateAndApplyPermission(permission);
    }

    public boolean isPermissionSet(Permission perm) {
        return this.hasPermission(perm);
    }

    public boolean isPermissionSet(String name) {
        return this.hasPermission(name);
    }
}

