/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.permission;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.pxstudios.minelib.permission.BukkitPermissibleObjectProvider;
import net.pxstudios.minelib.permission.PermissionDatabaseProvider;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.subscription.EventsSubscriber;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.PermissionAttachmentInfo;

public final class PlayerPermissionApi {
    private final Map<Player, BukkitPermissibleObjectProvider> permissibleByPlayersMap = new HashMap<Player, BukkitPermissibleObjectProvider>();
    private PermissionDatabaseProvider permissionDatabaseProvider;
    private boolean enabled;
    private boolean enabledOperatorsSystem;

    public PlayerPermissionApi(MinecraftPlugin plugin) {
        EventsSubscriber eventsSubscriber = plugin.getMineLibrary().getEventsSubscriber();
        eventsSubscriber.subscribe(PlayerJoinEvent.class, EventPriority.HIGHEST).complete(event -> {
            Player player = event.getPlayer();
            if (this.isEnabled()) {
                this.injectPermissibleBase(player, this.createPermissibleBase(player));
            }
        });
        eventsSubscriber.subscribe(PlayerQuitEvent.class, EventPriority.HIGHEST).complete(event -> this.permissibleByPlayersMap.remove(event.getPlayer()));
    }

    public PermissibleBase createPermissibleBase(Player player) {
        BukkitPermissibleObjectProvider permissible = new BukkitPermissibleObjectProvider(this, player);
        this.permissibleByPlayersMap.put(player, permissible);
        return permissible;
    }

    public void injectPermissibleBase(Player player, PermissibleBase permissibleBase) {
        Field field = player.getClass().getDeclaredField("perm");
        field.setAccessible(true);
        field.set(player, permissibleBase);
        field.setAccessible(false);
    }

    private BukkitPermissibleObjectProvider getCachedPermissible(Player player) {
        return this.enabled ? this.permissibleByPlayersMap.get(player) : null;
    }

    public void applyPermissionsMore(Player player, Collection<String> permissions) {
        BukkitPermissibleObjectProvider permissible = this.getCachedPermissible(player);
        if (permissible != null) {
            permissible.applyPermissions(permissions);
        }
    }

    public void addPermission(Player player, String permission) {
        BukkitPermissibleObjectProvider permissible = this.getCachedPermissible(player);
        if (permissible != null) {
            permissible.addPermission(permission);
        }
    }

    public void removePermission(Player player, String permission) {
        BukkitPermissibleObjectProvider permissible = this.getCachedPermissible(player);
        if (permissible != null) {
            permissible.removePermission(permission);
        }
    }

    public Set<String> getPermissions(Player player) {
        BukkitPermissibleObjectProvider permissible = this.getCachedPermissible(player);
        if (permissible != null) {
            return permissible.getPermissions();
        }
        return player.getEffectivePermissions().stream().map(PermissionAttachmentInfo::getPermission).collect(Collectors.toSet());
    }

    public boolean hasPermission(Player player, String permission) {
        return player.hasPermission(permission);
    }

    public PermissionDatabaseProvider getPermissionDatabaseProvider() {
        return this.permissionDatabaseProvider;
    }

    public void setPermissionDatabaseProvider(PermissionDatabaseProvider permissionDatabaseProvider) {
        this.permissionDatabaseProvider = permissionDatabaseProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabledOperatorsSystem() {
        return this.enabledOperatorsSystem;
    }

    public void setEnabledOperatorsSystem(boolean enabledOperatorsSystem) {
        this.enabledOperatorsSystem = enabledOperatorsSystem;
    }
}

