/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.registry.provider.type;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.pxstudios.minelib.command.CommandContext;
import net.pxstudios.minelib.command.CommandSettings;
import net.pxstudios.minelib.command.type.AbstractContextCommand;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.registry.BukkitRegistryObject;
import net.pxstudios.minelib.registry.provider.BukkitRegistryObjectProvider;
import net.pxstudios.minelib.registry.type.CommandRegistryObject;
import org.bukkit.plugin.Plugin;

public class CommandRegistryObjectProvider
implements BukkitRegistryObjectProvider<AbstractContextCommand> {
    @Override
    public void fireRegister(MinecraftPlugin plugin, AbstractContextCommand obj) {
        if (obj != null) {
            plugin.getMineLibrary().getCommandRegistry().registerCommand(obj);
        }
    }

    @Override
    public AbstractContextCommand newObjectInstance(MinecraftPlugin plugin, BukkitRegistryObject<AbstractContextCommand> bukkitRegistryObject) {
        Method processMethod = this.getProcessMethod(bukkitRegistryObject);
        if (processMethod == null) {
            return null;
        }
        Set<CommandSettings<?>> settings = this.getSettings(bukkitRegistryObject);
        Set<String> aliases = this.getAliases(bukkitRegistryObject);
        return this.newCommandObj((Plugin)plugin, bukkitRegistryObject, aliases, settings, processMethod);
    }

    private Method getProcessMethod(BukkitRegistryObject<AbstractContextCommand> bukkitRegistryObject) {
        try {
            return bukkitRegistryObject.getClass().getMethod("process", CommandContext.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Set<CommandSettings<?>> getSettings(BukkitRegistryObject<AbstractContextCommand> bukkitRegistryObject) {
        try {
            for (Method method : bukkitRegistryObject.getClass().getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || !method.getReturnType().isAssignableFrom(Collection.class) || !method.isAnnotationPresent(CommandRegistryObject.SettingsMethod.class)) continue;
                Collection collection = (Collection)method.invoke(bukkitRegistryObject, new Object[0]);
                return new HashSet(collection);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Set<String> getAliases(BukkitRegistryObject<AbstractContextCommand> bukkitRegistryObject) {
        try {
            CommandRegistryObject.MultipleAliases multipleAliases = bukkitRegistryObject.getClass().getDeclaredAnnotation(CommandRegistryObject.MultipleAliases.class);
            if (multipleAliases == null) {
                return null;
            }
            HashSet<String> aliases = new HashSet<String>();
            for (CommandRegistryObject.Alias alias : multipleAliases.value()) {
                aliases.add(alias.value());
            }
            return aliases;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private AbstractContextCommand newCommandObj(Plugin plugin, final BukkitRegistryObject<AbstractContextCommand> bukkitRegistryObject, Set<String> aliases, Set<CommandSettings<?>> settings, final Method invoker) {
        if (aliases == null || aliases.isEmpty()) {
            return null;
        }
        AbstractContextCommand commandInstance = new AbstractContextCommand(){

            @Override
            public void process(CommandContext context) {
                invoker.invoke((Object)bukkitRegistryObject, context);
            }
        };
        if (settings != null && !settings.isEmpty()) {
            commandInstance.getSettings().addAll(settings);
        }
        commandInstance.getActiveLabels().addAll(aliases);
        return commandInstance;
    }
}

