/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.world;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import net.pxstudios.minelib.plugin.MinecraftPlugin;
import net.pxstudios.minelib.subscription.EventsSubscriber;
import net.pxstudios.minelib.world.WrapperBukkitWorld;
import net.pxstudios.minelib.world.rule.WorldGameRule;
import net.pxstudios.minelib.world.rule.WorldGameRuleType;
import net.pxstudios.minelib.world.time.WorldTimeType;
import net.pxstudios.minelib.world.weather.WorldWeatherType;
import org.apache.commons.io.FileUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public final class BukkitWorldsApi {
    private final MinecraftPlugin plugin;
    private final Map<World, WrapperBukkitWorld> wrapperWorldsMap = new HashMap<World, WrapperBukkitWorld>();
    private final Map<String, CompletableFuture<World>> worldsFuturesMap = new HashMap<String, CompletableFuture<World>>();
    private boolean isSubscribedOnWorldEvents;

    public WrapperBukkitWorld getWrapper(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return this.wrapperWorldsMap.computeIfAbsent(world, f -> new WrapperBukkitWorld(this.plugin, world));
    }

    public WrapperBukkitWorld getWrapper(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getWrapper(this.plugin.getServer().getWorld(name));
    }

    public void setSpawnLocation(World world, Location location) {
        world.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public void setSpawnLocation(WrapperBukkitWorld world, Location location) {
        this.setSpawnLocation(world.getBukkit(), location);
    }

    public World getMainWorld() {
        return (World)this.plugin.getServer().getWorlds().get(0);
    }

    public World getLastLoadedWorld() {
        return (World)Iterables.getLast((Iterable)this.plugin.getServer().getWorlds());
    }

    public void setDefaultGameRule(WrapperBukkitWorld world, WorldGameRuleType type) {
        world.setDefaultGameRuleValue(type);
    }

    public void setDefaultGameRule(World world, WorldGameRuleType type) {
        this.setDefaultGameRule(this.getWrapper(world), type);
    }

    public WorldGameRule getGameRule(WrapperBukkitWorld world, WorldGameRuleType type) {
        return world.getGameRuleValue(type);
    }

    public WorldGameRule getGameRule(World world, WorldGameRuleType type) {
        return this.getGameRule(this.getWrapper(world), type);
    }

    public WorldGameRuleType getGameRuleByName(String name) {
        for (WorldGameRuleType gameRuleType : WorldGameRuleType.values()) {
            if (!gameRuleType.name().equalsIgnoreCase(name) && !gameRuleType.getName().equalsIgnoreCase(name)) continue;
            return gameRuleType;
        }
        return null;
    }

    public WorldWeatherType getWeatherByName(String name) {
        for (WorldWeatherType weatherType : WorldWeatherType.values()) {
            if (!weatherType.isNamedBy(name)) continue;
            return weatherType;
        }
        return null;
    }

    public WorldTimeType getNearbyTimeByTicks(long minecraftTicks) {
        for (WorldTimeType timeType : WorldTimeType.values()) {
            if (timeType.getMinecraftTicks() > minecraftTicks) continue;
            return timeType;
        }
        return null;
    }

    public CompletableFuture<World> loadBukkitWorld(WorldCreator worldCreator) {
        World world = worldCreator.createWorld();
        this.plugin.getServer().getWorlds().add(world);
        if (!this.isSubscribedOnWorldEvents) {
            this.subscribeWorldEvents(this.plugin.getMineLibrary().getEventsSubscriber());
        }
        CompletableFuture<World> completableFuture = new CompletableFuture<World>();
        this.worldsFuturesMap.put(worldCreator.name().toLowerCase(), completableFuture);
        return completableFuture;
    }

    public CompletableFuture<World> loadBukkitWorld(String name) {
        return this.loadBukkitWorld(new WorldCreator(name));
    }

    public CompletableFuture<World> unloadBukkitWorld(World world, boolean canFolderDelete) {
        this.plugin.getServer().unloadWorld(world, false);
        this.plugin.getServer().getWorlds().remove(world);
        if (!this.isSubscribedOnWorldEvents) {
            this.subscribeWorldEvents(this.plugin.getMineLibrary().getEventsSubscriber());
        }
        CompletableFuture<World> completableFuture = new CompletableFuture<World>();
        if (canFolderDelete) {
            completableFuture.thenAccept(handle -> {
                try {
                    FileUtils.forceDelete((File)handle.getWorldFolder());
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        this.worldsFuturesMap.put(world.getName().toLowerCase(), completableFuture);
        return completableFuture;
    }

    public CompletableFuture<World> unloadBukkitWorld(World world) {
        return this.unloadBukkitWorld(world, false);
    }

    private void subscribeWorldEvents(EventsSubscriber eventsSubscriber) {
        if (this.isSubscribedOnWorldEvents) {
            return;
        }
        Consumer<WorldEvent> worldFuturesEventConsumer = event -> {
            World world = event.getWorld();
            CompletableFuture<World> completableFuture = this.worldsFuturesMap.remove(world.getName().toLowerCase());
            if (completableFuture != null) {
                completableFuture.complete(world);
            }
        };
        eventsSubscriber.subscribe(WorldLoadEvent.class, EventPriority.HIGHEST).complete(worldFuturesEventConsumer::accept);
        eventsSubscriber.subscribe(WorldUnloadEvent.class, EventPriority.HIGHEST).complete(worldFuturesEventConsumer::accept);
        BiConsumer<WrapperBukkitWorld.Flag, PlayerEvent> worldJoinEventConsumer = (flag, event) -> {
            Player player = event.getPlayer();
            WrapperBukkitWorld world = this.getWrapper(event.getPlayer().getWorld());
            if (world.hasFlag((WrapperBukkitWorld.Flag)((Object)flag))) {
                player.teleport(world.getBukkit().getSpawnLocation());
            }
        };
        eventsSubscriber.subscribe(PlayerJoinEvent.class).complete(event -> worldJoinEventConsumer.accept(WrapperBukkitWorld.Flag.PLAYER_SPAWN_TELEPORT_ON_JOIN, (PlayerEvent)event));
        eventsSubscriber.subscribe(PlayerRespawnEvent.class).complete(event -> worldJoinEventConsumer.accept(WrapperBukkitWorld.Flag.PLAYER_SPAWN_TELEPORT_ON_JOIN, (PlayerEvent)event));
        eventsSubscriber.subscribe(PlayerChangedWorldEvent.class).complete(event -> worldJoinEventConsumer.accept(WrapperBukkitWorld.Flag.PLAYER_SPAWN_TELEPORT_ON_CHANGED, (PlayerEvent)event));
        this.isSubscribedOnWorldEvents = true;
    }

    public BukkitWorldsApi(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }
}

