/*
 * Decompiled with CFR 0.152.
 */
package net.pxstudios.minelib.world.rule;

import net.pxstudios.minelib.world.rule.WorldGameRuleType;

public class WorldGameRule {
    private final WorldGameRuleType type;
    private String asString;
    private int asInt;
    private double asDouble;
    private boolean asBoolean;

    public WorldGameRule(WorldGameRuleType type, String value) {
        this.type = type;
        this.set(value);
    }

    public WorldGameRule set(String value) {
        this.asString = value;
        this.asBoolean = Boolean.parseBoolean(value);
        this.asInt = this.asBoolean ? 1 : 0;
        this.asDouble = this.asInt;
        try {
            this.asInt = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.asDouble = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public WorldGameRuleType getType() {
        return this.type;
    }

    public String getAsString() {
        return this.asString;
    }

    public int getAsInt() {
        return this.asInt;
    }

    public double getAsDouble() {
        return this.asDouble;
    }

    public boolean isAsBoolean() {
        return this.asBoolean;
    }
}

