/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.sql;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Set;
import lombok.NonNull;

public enum ColumnType {
    CHAR("CHAR($)"),
    VARCHAR("VARCHAR($)"),
    TINYTEXT,
    TEXT,
    MEDIUMTEXT,
    LARGETEXT,
    TINYINT,
    BOOL,
    SMALLINT,
    MEDIUMINT,
    INT,
    BIGINT,
    DECIMAL,
    FLOAT("FLOAT($)"),
    DOUBLE,
    DATE,
    TIME,
    DATETIME,
    TIMESTAMP,
    YEAR,
    ENUM,
    SET,
    JSON("TEXT"),
    BLOB;

    String name;

    public static ColumnType getFromField(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Class<Set> clazz = field.getType();
        if (clazz.isPrimitive()) {
            if (clazz.equals(Character.TYPE)) {
                return CHAR;
            }
            if (clazz.equals(Boolean.TYPE)) {
                return BOOL;
            }
            return clazz.equals(Float.TYPE) ? FLOAT : (clazz.equals(Double.TYPE) ? DOUBLE : INT);
        }
        if (clazz.equals(String.class)) {
            return VARCHAR;
        }
        if (clazz.equals(Set.class) || clazz.isAssignableFrom(Set.class)) {
            return JSON;
        }
        if (clazz.equals(Enum.class)) {
            return ENUM;
        }
        if (clazz.equals(Date.class)) {
            return DATE;
        }
        return JSON;
    }

    public String withMaxLength(int maxLength) {
        return this.name == null ? this.name() : this.name.replace("$", maxLength + "");
    }

    private ColumnType(String name) {
        this.name = name;
    }

    private ColumnType() {
    }
}

