/*
 * Decompiled with CFR 0.152.
 */
package net.soqul.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.soqul.TRepository;
import net.soqul.annotation.field.InitateColumn;
import net.soqul.cache.ResponseCache;
import net.soqul.impl.SoqulDto;
import net.soqul.impl.SoqulField;
import net.soqul.log.Log;
import net.soqul.sql.ColumnType;
import net.soqul.sql.Executor;
import net.soqul.util.JsonUtil;
import net.soqul.util.MD5Tool;

public class TRepositoryImpl<T>
implements TRepository<T> {
    private static final Log log = new Log("SoqulRepo");
    private static MD5Tool tool = new MD5Tool(System.getProperty("hashing_key", "nope"), "utf-8");
    private String table;
    private Executor executor;
    private ResponseCache<T> cache;
    private SoqulDto dto;

    @Override
    public void save(@NonNull T t) {
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        log.info("Saving class %s to SQL..", t.getClass().getName());
        StringBuilder builderNames = new StringBuilder();
        StringBuilder builderValues = new StringBuilder();
        StringBuilder builderValuesAndNames = new StringBuilder();
        int i = 0;
        if (this.dto == null) {
            log.warn("dto is null!", new Object[0]);
            return;
        }
        for (SoqulField field : this.dto.getFields()) {
            String end = ++i >= this.dto.getFields().size() ? "" : ", ";
            Object value = field.getDefaultValue();
            try {
                Field field1 = t.getClass().getDeclaredField(field.getName());
                field1.setAccessible(true);
                Object fieldValue = field1.get(t);
                if (fieldValue != null) {
                    value = field.getType() == ColumnType.JSON ? JsonUtil.to(fieldValue) : fieldValue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                log.warn("Cant get field value!", new Object[0]);
            }
            builderNames.append("`" + field.getInitateColumn().name() + "`" + end);
            builderValues.append("'" + (field.isHash() ? tool.encode(value.toString()).toString() : value) + "'" + end);
            if (field.isPrimaryKey()) continue;
            builderValuesAndNames.append("`" + field.getInitateColumn().name() + "` = '" + value + "'" + end);
        }
        String request = String.format("INSERT INTO `%s` (%s) VALUES (%s) ON DUPLICATE KEY UPDATE %s", this.table, builderNames, builderValues, builderValuesAndNames);
        this.executor.execute(false, request, new Object[0]);
    }

    @Override
    public void removeByPrimary(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        InitateColumn primaryInitateColumn = this.dto.getKeyField().getInitateColumn();
        String request = String.format("DELETE * FROM `" + this.table + "` WHERE `" + primaryInitateColumn.name() + "` = '" + (this.dto.getKeyField().getType() == ColumnType.JSON ? JsonUtil.to(object) : object.toString()) + "'", new Object[0]);
        this.executor.execute(false, request, new Object[0]);
    }

    @Override
    public T getByPrimary(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        InitateColumn primaryInitateColumn = this.dto.getKeyField().getInitateColumn();
        String request = String.format("SELECT * FROM `" + this.table + "` WHERE `" + primaryInitateColumn.name() + "` = '" + (this.dto.getKeyField().getType() == ColumnType.JSON ? JsonUtil.to(object) : object.toString()) + "' LIMIT 1", new Object[0]);
        return (T)(this.cache != null ? this.cache.putIfAbsent(request, this.executor, e -> this.requestByQuery(object, request)) : this.requestByQuery(object, request));
    }

    @Override
    public Collection<T> getAll() {
        ArrayList all = new ArrayList();
        this.executor.executeQuery(false, "SELECT * FROM `" + this.table + "`;", rs -> {
            while (rs.next()) {
                Object t = this.dto.getClazz().newInstance();
                for (SoqulField field : this.dto.getFields()) {
                    Field field1 = this.dto.getClazz().getDeclaredField(field.getName());
                    field1.setAccessible(true);
                    Object value = rs.getObject(field.getInitateColumn().name());
                    field1.set(t, field.getType() == ColumnType.JSON ? JsonUtil.from(value.toString(), field1.getClass()) : value);
                }
                all.add(t);
            }
            return null;
        });
        return all;
    }

    @Override
    public Collection<T> getByFilter(Predicate<T> filter) {
        return this.getAll().stream().filter(filter).collect(Collectors.toList());
    }

    @Deprecated
    private T requestByQuery(@NonNull Object object, String request) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        try {
            InitateColumn primaryInitateColumn = this.dto.getKeyField().getInitateColumn();
            Object t = this.dto.getClazz().newInstance();
            this.executor.executeQuery(false, request, rs -> {
                if (!rs.next()) {
                    return null;
                }
                for (SoqulField field : this.dto.getFields()) {
                    Field field1 = t.getClass().getDeclaredField(field.getName());
                    field1.setAccessible(true);
                    Object value = rs.getObject(field.getInitateColumn().name());
                    value = field.getType() == ColumnType.JSON ? JsonUtil.from(value.toString(), field1.getType()) : value;
                    field1.set(t, field.isHash() ? tool.decode(value.toString()) : value);
                }
                return null;
            });
            return (T)t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    String getTable() {
        return this.table;
    }

    Executor getExecutor() {
        return this.executor;
    }

    ResponseCache<T> getCache() {
        return this.cache;
    }

    SoqulDto getDto() {
        return this.dto;
    }

    TRepositoryImpl(String table, Executor executor, ResponseCache<T> cache, SoqulDto dto) {
        this.table = table;
        this.executor = executor;
        this.cache = cache;
        this.dto = dto;
    }
}

