/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.column;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.wonsi.column.type.BooleanType;
import net.wonsi.column.type.ColumnType;
import net.wonsi.column.type.DateType;
import net.wonsi.column.type.DatetimeType;
import net.wonsi.column.type.FloatType;
import net.wonsi.column.type.IntType;
import net.wonsi.column.type.VarcharType;

public final class ColumnUtil {
    private static Map<Class<?>, ColumnType> TYPE_MAP = new HashMap();

    public static ColumnType get(@NonNull Class<?> javaType) {
        if (javaType == null) {
            throw new NullPointerException("javaType is marked non-null but is null");
        }
        return TYPE_MAP.getOrDefault(javaType, new VarcharType());
    }

    private ColumnUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        TYPE_MAP.put(String.class, new VarcharType());
        TYPE_MAP.put(Boolean.class, new BooleanType());
        TYPE_MAP.put(Boolean.TYPE, new BooleanType());
        TYPE_MAP.put(Character.TYPE, new VarcharType());
        TYPE_MAP.put(Character.class, new VarcharType());
        TYPE_MAP.put(Date.class, new DateType());
        TYPE_MAP.put(Timestamp.class, new DatetimeType());
        TYPE_MAP.put(Short.TYPE, new IntType());
        TYPE_MAP.put(Integer.TYPE, new IntType());
        TYPE_MAP.put(Integer.class, new IntType());
        TYPE_MAP.put(Long.class, new IntType());
        TYPE_MAP.put(Short.class, new IntType());
        TYPE_MAP.put(Number.class, new IntType());
        TYPE_MAP.put(Byte.class, new IntType());
        TYPE_MAP.put(Long.TYPE, new IntType());
        TYPE_MAP.put(Byte.TYPE, new IntType());
        TYPE_MAP.put(Float.TYPE, new FloatType());
        TYPE_MAP.put(Double.TYPE, new FloatType());
        TYPE_MAP.put(BigDecimal.class, new FloatType());
    }
}

