/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.yookassa.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;
import net.suuft.yookassa.Yookassa;
import net.suuft.yookassa.exception.BadRequestException;
import net.suuft.yookassa.exception.UnspecifiedShopInformation;
import net.suuft.yookassa.type.Amount;
import net.suuft.yookassa.type.Payment;
import net.suuft.yookassa.type.Refund;
import net.suuft.yookassa.type.collecting.PaymentList;
import net.suuft.yookassa.type.collecting.RefundList;
import net.suuft.yookassa.type.request.PaymentRequest;
import net.suuft.yookassa.type.request.RefundRequest;
import net.suuft.yookassa.utility.JsonUtil;

public class RealYookassa
implements Yookassa {
    private int shopIdentifier;
    private String shopToken;

    @Override
    public Payment createPayment(@NonNull Amount amount, @NonNull String description, @NonNull String redirectUrl) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        return this.parseResponse(Payment.class, "https://api.yookassa.ru/v3/payments", "POST", JsonUtil.toJson(PaymentRequest.create(amount, redirectUrl, description)));
    }

    @Override
    public Payment getPayment(@NonNull UUID paymentIdentifier) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (paymentIdentifier == null) {
            throw new NullPointerException("paymentIdentifier is marked non-null but is null");
        }
        return this.parseResponse(Payment.class, "https://api.yookassa.ru/v3/payments/" + paymentIdentifier, "GET", null);
    }

    @Override
    public PaymentList getPayments() throws UnspecifiedShopInformation, BadRequestException, IOException {
        return this.parseResponse(PaymentList.class, "https://api.yookassa.ru/v3/payments", "GET", null);
    }

    @Override
    public Refund createRefund(@NonNull UUID paymentIdentifier, @NonNull Amount amount) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (paymentIdentifier == null) {
            throw new NullPointerException("paymentIdentifier is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return this.parseResponse(Refund.class, "https://api.yookassa.ru/v3/refunds", "POST", JsonUtil.toJson(new RefundRequest(amount, paymentIdentifier)));
    }

    @Override
    public Refund getRefund(@NonNull UUID refundIdentifier) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (refundIdentifier == null) {
            throw new NullPointerException("refundIdentifier is marked non-null but is null");
        }
        return this.parseResponse(Refund.class, "https://api.yookassa.ru/v3/refunds/" + refundIdentifier, "GET", null);
    }

    @Override
    public RefundList getRefunds() throws UnspecifiedShopInformation, BadRequestException, IOException {
        return this.parseResponse(RefundList.class, "https://api.yookassa.ru/v3/refunds", "GET", null);
    }

    private <T> T parseResponse(@NonNull Class<T> wannableClass, @NonNull String requestAddress, @NonNull String requestMethod, String writableJson) throws IOException, UnspecifiedShopInformation, BadRequestException {
        String response;
        if (wannableClass == null) {
            throw new NullPointerException("wannableClass is marked non-null but is null");
        }
        if (requestAddress == null) {
            throw new NullPointerException("requestAddress is marked non-null but is null");
        }
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        if (this.shopIdentifier == 0 || this.shopToken == null) {
            throw new UnspecifiedShopInformation();
        }
        URL url = new URL(requestAddress);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod(requestMethod);
        byte[] message = (this.shopIdentifier + ":" + this.shopToken).getBytes(StandardCharsets.UTF_8);
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])message);
        httpConn.setRequestProperty("Authorization", "Basic " + basicAuth);
        if (writableJson != null) {
            httpConn.setRequestProperty("Idempotence-Key", UUID.randomUUID().toString());
            httpConn.setRequestProperty("Content-Type", "application/json");
            httpConn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
            writer.write(writableJson);
            writer.flush();
            writer.close();
            httpConn.getOutputStream().close();
        }
        boolean success = httpConn.getResponseCode() / 100 == 2;
        InputStream responseStream = success ? httpConn.getInputStream() : httpConn.getErrorStream();
        Scanner s = new Scanner(responseStream).useDelimiter("\\A");
        String string = response = s.hasNext() ? s.next() : "";
        if (!success) {
            System.out.println(response);
            throw new BadRequestException();
        }
        return JsonUtil.fromJson(response, wannableClass);
    }

    public RealYookassa(int shopIdentifier, String shopToken) {
        this.shopIdentifier = shopIdentifier;
        this.shopToken = shopToken;
    }
}

