/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.yookassa;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import net.suuft.yookassa.exception.BadRequestException;
import net.suuft.yookassa.exception.UnspecifiedShopInformation;
import net.suuft.yookassa.type.Payment;
import net.suuft.yookassa.type.PaymentRequest;

public final class YookassaJavaSdk {
    public static URL PAYMENT_API_URL;
    private static int shopId;
    private static String shopToken;

    public static Payment createPayment(BigDecimal value, String currency, String description, String redirectUrl) throws UnspecifiedShopInformation, BadRequestException, IOException {
        String response;
        if (shopId == 0 || shopToken == null) {
            throw new UnspecifiedShopInformation();
        }
        HttpURLConnection httpConn = (HttpURLConnection)PAYMENT_API_URL.openConnection();
        httpConn.setRequestMethod("POST");
        byte[] message = (shopId + ":" + shopToken).getBytes(StandardCharsets.UTF_8);
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])message);
        httpConn.setRequestProperty("Authorization", "Basic " + basicAuth);
        httpConn.setRequestProperty("Idempotence-Key", UUID.randomUUID().toString());
        httpConn.setRequestProperty("Content-Type", "application/json");
        httpConn.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
        writer.write(PaymentRequest.create(value, currency, redirectUrl, description).toJson());
        writer.flush();
        writer.close();
        httpConn.getOutputStream().close();
        boolean success = httpConn.getResponseCode() / 100 == 2;
        InputStream responseStream = success ? httpConn.getInputStream() : httpConn.getErrorStream();
        Scanner s = new Scanner(responseStream).useDelimiter("\\A");
        String string = response = s.hasNext() ? s.next() : "";
        if (!success) {
            System.out.println(response);
            throw new BadRequestException();
        }
        return Payment.fromJson(response);
    }

    public static Payment createPayment(BigDecimal value, String description, String redirectUrl) throws UnspecifiedShopInformation, BadRequestException, IOException {
        return YookassaJavaSdk.createPayment(value, "RUB", description, redirectUrl);
    }

    public static Payment createPayment(BigDecimal value, String description) throws UnspecifiedShopInformation, BadRequestException, IOException {
        return YookassaJavaSdk.createPayment(value, description, "https://discord.com/404");
    }

    private YookassaJavaSdk() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setShopId(int shopId) {
        YookassaJavaSdk.shopId = shopId;
    }

    public static void setShopToken(String shopToken) {
        YookassaJavaSdk.shopToken = shopToken;
    }

    static {
        shopId = 0;
        try {
            PAYMENT_API_URL = new URL("https://api.yookassa.ru/v3/payments");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

