# pachyderm
_a very large mammal with thick skin, especially an elephant, rhinoceros, or hippopotamus._

[![Clojars Project](https://img.shields.io/clojars/v/works-hub/pachyderm.svg)](https://clojars.org/works-hub/pachyderm)[![CircleCI](https://circleci.com/gh/Works-Hub/pachyderm.svg?style=svg)](https://circleci.com/gh/Works-Hub/pachyderm)

A modern (no, really!) Clojure client for the [Stripe API](https://stripe.com/docs/api).
**This is a spiritual fork of [Elephant from ClojureWerkz](https://github.com/clojurewerkz/elephant) and is therefore acknowledged as a primary influence on Pachyderm**

Pachyderm wraps the [stripe-java bindings](https://github.com/stripe/stripe-java) - currently `7.0.0`

## Examples

### Getting Started

``` clojure
;; set global api key
(require '[works-hub.pachyderm.client :as client])

(client/set-api-key! "xxxxxxx")
```

### Customers

``` clojure
(require '[works-hub.pachyderm.customers :as customers])

;; create a new customer
;; https://stripe.com/docs/api?lang=java#create_customer
(def a (customers/create {:source "tok_mastercard"})

;; update a customer
;; https://stripe.com/docs/api?lang=java#update_customer
(def b (customers/update c {:description "Foo bar baz"}

;; delete a customer
;; https://stripe.com/docs/api?lang=java#delete_customer
(def c (customers/delete b)
```

## Testing

There is a suite of integration tests that can be run with the following command:

``` bash
STRIPE_API_KEY=xxxxx lein test
```

## TODO
 - More examples in the README
 - More API coverage (charges, invoice items, balances, coupons etc)
 - More tests

 Pull requests very welcome!

## License

Copyright © 2018 WorksHub

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
