(ns works-hub.pachyderm.plans
  (:refer-clojure :exclude [list update])
  (:require [clojure.string :as str]
            [works-hub.pachyderm.transforms :as trs]
            [works-hub.pachyderm.util :refer (map->request-options map->str-ks)])
  (:import [clojure.lang IPersistentMap]
           [com.stripe.exception InvalidRequestException]
           [com.stripe.model Plan]))

(defn list
  ([]
   (list {}))
  ([^IPersistentMap attrs]
   (list attrs nil))
  ([^IPersistentMap attrs ^IPersistentMap ro-opts]
   (trs/plans-coll->seq (Plan/list
                         (map->str-ks attrs)
                         (map->request-options ro-opts)))))

(defn create
  ([^IPersistentMap attrs]
   (create attrs nil))
  ([^IPersistentMap attrs ^IPersistentMap ro-opts]
   (trs/plan->map (Plan/create
                   (map->str-ks attrs)
                   (map->request-options ro-opts)))))

(defn retrieve
  ([^String id]
   (retrieve id nil))
  ([^String id ^IPersistentMap ro-opts]
   (try
     (trs/plan->map (Plan/retrieve
                     id
                     (map->request-options ro-opts)))
     (catch InvalidRequestException e
       (when-not (str/starts-with? (.getMessage e) "No such plan")
         (throw e))))))

(defn update
  ([^IPersistentMap plan ^IPersistentMap attrs]
   (update plan attrs nil))
  ([^IPersistentMap plan ^IPersistentMap attrs ^IPersistentMap ro-opts]
   (if-let [o (:__origin__ plan)]
     (trs/plan->map (.update o
                             (map->str-ks attrs)
                             (map->request-options ro-opts)))
     (throw (IllegalArgumentException.
             "plans/update only accepts maps returned by plans/create, plans/retrieve, and plans/list")))))

(defn delete
  ([^IPersistentMap plan]
   (delete plan nil))
  ([^IPersistentMap plan ^IPersistentMap ro-opts]
   (if-let [o (:__origin__ plan)]
     (trs/plan->map (.delete o (map->request-options ro-opts)))
     (throw (IllegalArgumentException.
             "plans/delete only accepts maps returned by plans/create, plans/retrieve, and plans/list")))))
