(ns works-hub.pachyderm.util
  (:require [clojure.walk :as wlk])
  (:import [com.stripe.net RequestOptions]))

(def map->str-ks wlk/stringify-keys)
(def map->kw-ks wlk/keywordize-keys)

(defn map->request-options
  [{:keys [idempotency-key
           connection-timeout
           read-timeout
           api-key] :as args}]
  (when (not-empty args))
  (let [ro (RequestOptions/builder)]
    (when idempotency-key
      (.setIdempotencyKey ro idempotency-key))
    (when connection-timeout
      (.setConnectTimeout ro connection-timeout))
    (when read-timeout
      (.setReadTimeout ro read-timeout))
    (when api-key
      (.setApiKey ro api-key))
    (.build ro)))
