from __future__ import print_function
import collections
import sys


def iter_tokens(tokens):
    for token in tokens:
        if token.startswith('//'):
            break
        yield token


def parse_lines(lines):
    class_infos =  collections.defaultdict(list)
    klass = None
    for line in lines:
        if line.startswith('//'):
            continue
        tokens = list(filter(bool, map(str.strip, line.split())))
        i = 0
        if tokens and tokens[0].startswith('?'):
            klass = tokens[0]
            i += 1
        if klass is None:
            continue
        class_info = class_infos[klass]
        if class_info is None:
            continue
        toks = tokens[i:]
        if not toks:
            continue
        tokens = iter_tokens(toks)
        next_token = lambda : next(tokens, None)
        attr_info = collections.OrderedDict()
        attr_info['tag'] = next_token()
        attr_info['ref_cls'] = next_token()
        attr_info['xref'] = next_token()
        attr_info['ref_tag'] = next_token()
        attr_info['hash'] = next_token()
        class_infos[klass].append(attr_info)
    return class_infos


def make_xref_map(lines, direction):
    xref_type = '{}XREF'.format(direction.upper())
    xref_map = collections.OrderedDict()
    all_class_infos = parse_lines(lines)
    for (klass, infos) in all_class_infos.items():
        for info in filter(lambda attr: attr['xref'] == xref_type, infos):
            key = (klass, info['tag'])
            assert key not in xref_map
            xref_map[key] = (info['ref_cls'], info['ref_tag'])
    return xref_map

def main(*args):
    import sys
    try:
        direction = args[1].upper()
        if direction not in ('IN', 'OUT'):
            raise ValueError('Specify "IN" or "OUT"')
    except (ValueError, IndexError):
        print('Usage:', sys.executable, args[0], '[IN|OUT]')
        sys.exit(1)
    with open('models.wrm.annot') as fp:
        xref_map = make_xref_map(fp.readlines(), direction)
        for (src, dst) in xref_map.items():
            match = src == xref_map.get(dst)
            if match:
                print('Circular',
                      direction.upper() + 'REF between',
                      ' '.join(src), 'and', ' '.join(dst))


if __name__ == '__main__':
    main(*sys.argv)
