/*
 * Decompiled with CFR 0.152.
 */
package clojure_csv;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.LockingTransaction;
import clojure.lang.Namespace;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import clojure_csv.core$crlf_at_reader_pos_QMARK_;
import clojure_csv.core$custom_eol_at_reader_pos_QMARK_;
import clojure_csv.core$eol_at_reader_pos_QMARK_;
import clojure_csv.core$escape;
import clojure_csv.core$escaped_quote_at_reader_pos_QMARK_;
import clojure_csv.core$fn__2430;
import clojure_csv.core$lf_at_reader_pos_QMARK_;
import clojure_csv.core$loading__5569__auto____2428;
import clojure_csv.core$needs_quote_QMARK_;
import clojure_csv.core$parse_csv;
import clojure_csv.core$parse_csv_line;
import clojure_csv.core$parse_csv_with_options;
import clojure_csv.core$quote_and_escape;
import clojure_csv.core$quote_and_escape_row;
import clojure_csv.core$read_quoted_field;
import clojure_csv.core$read_unquoted_field;
import clojure_csv.core$reader_peek;
import clojure_csv.core$skip_past_eol;
import clojure_csv.core$write_csv;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class core__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__4;
    public static final AFn const__5;
    public static final Var const__6;
    public static final AFn const__15;
    public static final Var const__16;
    public static final AFn const__19;
    public static final Var const__20;
    public static final AFn const__23;
    public static final Var const__24;
    public static final AFn const__27;
    public static final Var const__28;
    public static final AFn const__31;
    public static final Var const__32;
    public static final AFn const__35;
    public static final Var const__36;
    public static final AFn const__39;
    public static final Var const__40;
    public static final AFn const__43;
    public static final Var const__44;
    public static final AFn const__47;
    public static final Var const__48;
    public static final AFn const__51;
    public static final Var const__52;
    public static final AFn const__55;
    public static final Var const__56;
    public static final AFn const__59;
    public static final Var const__60;
    public static final AFn const__63;
    public static final Var const__64;
    public static final AFn const__67;
    public static final Var const__68;
    public static final AFn const__71;
    public static final Var const__72;
    public static final AFn const__75;
    public static final Var const__76;
    public static final AFn const__79;

    public static void load() {
        Object v3;
        Object object = ((IFn)const__0.getRawRoot()).invoke((Object)const__1);
        IPersistentMap iPersistentMap = ((AReference)Namespace.find((Symbol)((Symbol)const__1))).resetMeta((IPersistentMap)const__4);
        Object object2 = ((IFn)new core$loading__5569__auto____2428()).invoke();
        if (((Symbol)const__1).equals((Object)const__5)) {
            v3 = null;
        } else {
            LockingTransaction.runInTransaction((Callable)((Callable)((Object)new core$fn__2430())));
            v3 = null;
        }
        Var var = const__6;
        var.setMeta((IPersistentMap)const__15);
        Var var2 = var;
        var.bindRoot((Object)new core$reader_peek());
        Var var3 = const__16;
        var3.setMeta((IPersistentMap)const__19);
        Var var4 = var3;
        var3.bindRoot((Object)new core$lf_at_reader_pos_QMARK_());
        Var var5 = const__20;
        var5.setMeta((IPersistentMap)const__23);
        Var var6 = var5;
        var5.bindRoot((Object)new core$crlf_at_reader_pos_QMARK_());
        Var var7 = const__24;
        var7.setMeta((IPersistentMap)const__27);
        Var var8 = var7;
        var7.bindRoot((Object)new core$custom_eol_at_reader_pos_QMARK_());
        Var var9 = const__28;
        var9.setMeta((IPersistentMap)const__31);
        Var var10 = var9;
        var9.bindRoot((Object)new core$eol_at_reader_pos_QMARK_());
        Var var11 = const__32;
        var11.setMeta((IPersistentMap)const__35);
        Var var12 = var11;
        var11.bindRoot((Object)new core$skip_past_eol());
        Var var13 = const__36;
        var13.setMeta((IPersistentMap)const__39);
        Var var14 = var13;
        var13.bindRoot((Object)new core$read_unquoted_field());
        Var var15 = const__40;
        var15.setMeta((IPersistentMap)const__43);
        Var var16 = var15;
        var15.bindRoot((Object)new core$escaped_quote_at_reader_pos_QMARK_());
        Var var17 = const__44;
        var17.setMeta((IPersistentMap)const__47);
        Var var18 = var17;
        var17.bindRoot((Object)new core$read_quoted_field());
        Var var19 = const__48;
        var19.setMeta((IPersistentMap)const__51);
        Var var20 = var19;
        var19.bindRoot((Object)new core$parse_csv_line());
        Var var21 = const__52;
        var21.setMeta((IPersistentMap)const__55);
        Var var22 = var21;
        var21.bindRoot((Object)new core$parse_csv_with_options());
        Var var23 = const__56;
        var23.setMeta((IPersistentMap)const__59);
        Var var24 = var23;
        var23.bindRoot((Object)new core$parse_csv());
        Var var25 = const__60;
        var25.setMeta((IPersistentMap)const__63);
        Var var26 = var25;
        var25.bindRoot((Object)new core$needs_quote_QMARK_());
        Var var27 = const__64;
        var27.setMeta((IPersistentMap)const__67);
        Var var28 = var27;
        var27.bindRoot((Object)new core$escape());
        Var var29 = const__68;
        var29.setMeta((IPersistentMap)const__71);
        Var var30 = var29;
        var29.bindRoot((Object)new core$quote_and_escape());
        Var var31 = const__72;
        var31.setMeta((IPersistentMap)const__75);
        Var var32 = var31;
        var31.bindRoot((Object)new core$quote_and_escape_row());
        Var var33 = const__76;
        var33.setMeta((IPersistentMap)const__79);
        Var var34 = var33;
        var33.bindRoot((Object)new core$write_csv());
    }

    public static void __init0() {
        const__0 = RT.var((String)"clojure.core", (String)"in-ns");
        const__1 = (AFn)((IObj)Symbol.intern(null, (String)"clojure-csv.core")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"author"), "David Santiago", RT.keyword(null, (String)"doc"), "Clojure-CSV is a small library for reading and writing CSV files.\nIt correctly handles common CSV edge-cases, such as embedded newlines, commas,\nand quotes. The main functions are parse-csv and write-csv."}));
        const__4 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"author"), "David Santiago", RT.keyword(null, (String)"doc"), "Clojure-CSV is a small library for reading and writing CSV files.\nIt correctly handles common CSV edge-cases, such as embedded newlines, commas,\nand quotes. The main functions are parse-csv and write-csv."});
        const__5 = (AFn)Symbol.intern(null, (String)"clojure.core");
        const__6 = RT.var((String)"clojure-csv.core", (String)"reader-peek");
        const__15 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")})))), RT.keyword(null, (String)"line"), 15, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__16 = RT.var((String)"clojure-csv.core", (String)"lf-at-reader-pos?");
        const__19 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")}))))), RT.keyword(null, (String)"doc"), "Given a reader, returns true if the reader is currently pointing at an \n\n   character. Reader will not be changed when the function returns.", RT.keyword(null, (String)"line"), 26, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__20 = RT.var((String)"clojure-csv.core", (String)"crlf-at-reader-pos?");
        const__23 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")}))))), RT.keyword(null, (String)"doc"), "Given a reader, returns true if the reader is currently pointing at an \r\n\n   character sequence. Reader will not be changed when the function returns.", RT.keyword(null, (String)"line"), 33, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__24 = RT.var((String)"clojure-csv.core", (String)"custom-eol-at-reader-pos?");
        const__27 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)((IObj)Symbol.intern(null, (String)"end-of-line")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"String")}))))), RT.keyword(null, (String)"doc"), "Given a reader and an end-of-line string, returns true if the reader is\n   currently pointing at an instance of the end-of-line string. Reader will not\n   be changed when the function returns.", RT.keyword(null, (String)"line"), 43, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__28 = RT.var((String)"clojure-csv.core", (String)"eol-at-reader-pos?");
        const__31 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")}))), Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)Symbol.intern(null, (String)"end-of-line")))), RT.keyword(null, (String)"doc"), "Given a reader and optionally an end-of-line string, returns true if the\n   reader is currently pointing at an end-of-line (LF/CRLF/the end-of-line arg).\n   Reader will not be changed when the function returns. Note that if the\n   EOL is specified, it will not check for LF/CRLF.", RT.keyword(null, (String)"line"), 62, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__32 = RT.var((String)"clojure-csv.core", (String)"skip-past-eol");
        const__35 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")}))), Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)Symbol.intern(null, (String)"end-of-line")))), RT.keyword(null, (String)"doc"), "Given a reader that is pointing at an end-of-line\n   (LF/CRLF/the end-of-line arg), moves the reader forward to the\n   first character after the end-of-line sequence. Note that if the EOL is\n   specified, it will not check for LF/CRLF.", RT.keyword(null, (String)"line"), 75, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__36 = RT.var((String)"clojure-csv.core", (String)"read-unquoted-field");
        const__39 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"strict"), (Object)Symbol.intern(null, (String)"end-of-line")))), RT.keyword(null, (String)"doc"), "Given a reader that is queued up to the beginning of an unquoted field,\n   reads the field and returns it as a string. The reader will be left at the\n   first character past the end of the field.", RT.keyword(null, (String)"line"), 93, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__40 = RT.var((String)"clojure-csv.core", (String)"escaped-quote-at-reader-pos?");
        const__43 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)((IObj)Symbol.intern(null, (String)"quote-char")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")}))))), RT.keyword(null, (String)"doc"), "Given a reader, returns true if it is currently pointing at a character that\n   is the same as quote-char. The reader position will not be changed when the\n   function returns.", RT.keyword(null, (String)"line"), 113, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__44 = RT.var((String)"clojure-csv.core", (String)"read-quoted-field");
        const__47 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)((IObj)Symbol.intern(null, (String)"delimiter")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")})), (Object)((IObj)Symbol.intern(null, (String)"quote-char")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"long")})), (Object)Symbol.intern(null, (String)"strict")))), RT.keyword(null, (String)"doc"), "Given a reader that is queued up to the beginning of a quoted field,\n   reads the field and returns it as a string. The reader will be left at the\n   first character past the end of the field.", RT.keyword(null, (String)"line"), 124, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__48 = RT.var((String)"clojure-csv.core", (String)"parse-csv-line");
        const__51 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"csv-reader")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"Reader")})), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"strict"), (Object)Symbol.intern(null, (String)"end-of-line")))), RT.keyword(null, (String)"doc"), "Takes a Reader as input and returns the first row of the CSV file,\n   parsed into cells (an array of strings). The reader passed in will be\n   positioned for the start of the next line.", RT.keyword(null, (String)"line"), 153, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__52 = RT.var((String)"clojure-csv.core", (String)"parse-csv-with-options");
        const__55 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"csv-reader"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"strict"), (Object)Symbol.intern(null, (String)"end-of-line"))})), Tuple.create((Object)Symbol.intern(null, (String)"csv-reader"), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"strict"), (Object)Symbol.intern(null, (String)"end-of-line")))), RT.keyword(null, (String)"line"), 187, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__56 = RT.var((String)"clojure-csv.core", (String)"parse-csv");
        const__59 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"csv"), (Object)Symbol.intern(null, (String)"&"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"as"), Symbol.intern(null, (String)"opts")})))), RT.keyword(null, (String)"doc"), "Takes a CSV as a string or Reader and returns a seq of the parsed CSV rows,\n   in the form of a lazy sequence of vectors: a vector per row, a string for\n   each cell.\n\n   Accepts a number of keyword arguments to change the parsing behavior:\n        :delimiter - A character that contains the cell separator for\n                     each column in a row.  Default value: \\,\n        :end-of-line - A string containing the end-of-line character\n                       for reading CSV files. If this setting is nil then\n                       \\n and \\r\\n are both accepted.  Default value: nil\n        :quote-char - A character that is used to begin and end a quoted cell.\n                      Default value: \\\"\n        :strict - If this variable is true, the parser will throw an\n                  exception on parse errors that are recoverable but\n                  not to spec or otherwise nonsensical.  Default value: false", RT.keyword(null, (String)"line"), 199, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__60 = RT.var((String)"clojure-csv.core", (String)"needs-quote?");
        const__63 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)((IObj)Symbol.intern(null, (String)"cell")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"tag"), Symbol.intern(null, (String)"String")})), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char")))), RT.keyword(null, (String)"doc"), "Given a string (cell), determine whether it contains a character that\n   requires this cell to be quoted.", RT.keyword(null, (String)"line"), 226, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__64 = RT.var((String)"clojure-csv.core", (String)"escape");
        const__67 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"chr"), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char")))), RT.keyword(null, (String)"doc"), "Given a character, returns the escaped version, whether that is the same\n   as the original character or a replacement. The return is a string or a\n   character, but it all gets passed into str anyways.", RT.keyword(null, (String)"line"), 235, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__68 = RT.var((String)"clojure-csv.core", (String)"quote-and-escape");
        const__71 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"cell"), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"force-quote")))), RT.keyword(null, (String)"doc"), "Given a string (cell), returns a new string that has any necessary quoting\n   and escaping.", RT.keyword(null, (String)"line"), 242, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__72 = RT.var((String)"clojure-csv.core", (String)"quote-and-escape-row");
        const__75 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"row"), (Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"force-quote")))), RT.keyword(null, (String)"doc"), "Given a row (vector of strings), quotes and escapes any cells where that\n   is necessary and then joins all the text into a string for that entire row.", RT.keyword(null, (String)"line"), 253, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
        const__76 = RT.var((String)"clojure-csv.core", (String)"write-csv");
        const__79 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"table"), (Object)Symbol.intern(null, (String)"&"), (Object)RT.map((Object[])new Object[]{RT.keyword(null, (String)"keys"), Tuple.create((Object)Symbol.intern(null, (String)"delimiter"), (Object)Symbol.intern(null, (String)"quote-char"), (Object)Symbol.intern(null, (String)"end-of-line"), (Object)Symbol.intern(null, (String)"force-quote")), RT.keyword(null, (String)"or"), RT.map((Object[])new Object[]{Symbol.intern(null, (String)"delimiter"), Character.valueOf(','), Symbol.intern(null, (String)"quote-char"), Character.valueOf('\"'), Symbol.intern(null, (String)"end-of-line"), "\n", Symbol.intern(null, (String)"force-quote"), Boolean.FALSE})})))), RT.keyword(null, (String)"doc"), "Given a sequence of sequences of strings, returns a string of that table\n   in CSV format, with all appropriate quoting and escaping.\n\n   Accepts a number of keyword arguments to change the output:\n       :delimiter - A character that contains the cell separator for\n                    each column in a row.  Default value: \\,\n       :end-of-line - A string containing the end-of-line character\n                      for writing CSV files.  Default value: \\n\n       :quote-char - A character that is used to begin and end a quoted cell.\n                     Default value: \\\"\n       :force-quote - Forces every cell to be quoted (useful for Excel interop)\n                      Default value: false", RT.keyword(null, (String)"line"), 263, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure_csv/core.clj"});
    }

    static {
        core__init.__init0();
        Compiler.pushNSandLoader((ClassLoader)RT.classForName((String)"clojure_csv.core__init").getClassLoader());
        try {
            core__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

