Simple text auto completion library written in ClojureScript using `goog.ui.ac.AutoComplete`

## Usage

### ClojureScript

First, add dependency to your project: `[xafizoff/auto-complete "0.1.0-SNAPSHOT"]`

Require namespace: `(require '[xafizoff.ac :as ac])`

```clojure
(ac/wrap (js/document.getElementById "my-input") ["my" "suggestion" "list"])
```

### JavaScript

```html
<script src="autocomplete.js" type="application/javascript"></script> 
```

```javascript
xafizoff.ac.wrap(document.getElementById('my-input'), ['my', 'suggestion', 'list']);
```

Signature:
```
wrap(input, suggestion_source);
wrap(input, suggestion_area, suggestion_source);
```
where 
* `input` -- `<input type=text>` or `<textarea>`
* `suggestion_area` -- element to hold popup elements
* `suggestion_source` -- source for the suggestions

### Suggestion sources

You can simply pass an array or vector (in cljs). It is also possible to use a function
with signature: `function(token, max_matches) {}` which must return an array (or vector)
of strings, matching to `token`.

In addition, in ClojureScript you can extend type with protocol `xafizoff.ac.IACSuggest` and
use this type as suggestion source.



## License

Copyright  2018 Marat Khafizov

Distributed under the Eclipse Public License version 1.0
