/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Task;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Modifiers {
    protected boolean changed;
    protected Task task;
    protected String mods;
    protected String remaining;
    protected String arbTagAttr = "";
    protected String style = "";
    protected String cssClass = "";
    protected String id = "";
    protected String lang = "";
    protected Halign halign = Halign.unassigned;
    protected int lpad;
    protected int rpad;
    protected Valign valign = Valign.unassigned;
    protected String colspan = "";
    protected String rowspan = "";
    private boolean image;
    private boolean table;
    private boolean header;
    private boolean columns;
    public String colWidth = "";
    private static final String CLASS_ID_REGEX = "\\(((\\w|[#,-]|\\d)+)\\)";
    private static final Pattern CLASS_ID_PATTERN = Pattern.compile("\\(((\\w|[#,-]|\\d)+)\\)");
    private static final String ARB_TAG_ATT_REGEX = "\\{\\{([\\S &&[^}]]+)\\}\\}";
    private static final Pattern ARB_TAG_ATT_PATTERN = Pattern.compile("\\{\\{([\\S &&[^}]]+)\\}\\}");
    private static final String STYLE_REGEX = "\\{([\\S &&[^}]]+)\\}";
    private static final Pattern STYLE_PATTERN = Pattern.compile("\\{([\\S &&[^}]]+)\\}");
    private static final String LANG_REGEX = "\\[([a-zA-Z0-9-]+)\\]";
    private static final Pattern LANG_PATTERN = Pattern.compile("\\[([a-zA-Z0-9-]+)\\]");
    private static final String COL_SPAN_REGEX = "\\\\(\\d+)";
    private static final String ROW_SPAN_REGEX = "/(\\d+)";
    private static final String SYMS_REGEX = "_|-|\\^|~|>|<|=|\\(+|\\)+";
    public static final String REGEX_7 = "(?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*";
    private static final Pattern COL_SPAN_PATTERN = Pattern.compile("\\\\(\\d+)");
    private static final Pattern ROW_SPAN_PATTERN = Pattern.compile("/(\\d+)");

    protected Modifiers(Task task, String string) {
        this.task = task;
        String string2 = this.mods = string == null ? "" : string.trim();
        if (this.mods.equals("")) {
            return;
        }
        this.parse();
    }

    public String toString() {
        return this.mods;
    }

    public String getRemaining() {
        return this.remaining;
    }

    protected void parse() {
        int n;
        Object object;
        if (this.mods == null || this.mods.equals("")) {
            return;
        }
        this.remaining = this.mods;
        if (this.remaining.indexOf(40) != -1 && ((Matcher)(object = CLASS_ID_PATTERN.matcher(this.remaining))).find()) {
            String string = ((Matcher)object).group(1);
            n = string.indexOf(35);
            this.id = n == -1 ? "" : string.substring(n + 1);
            this.cssClass = n == -1 ? string : string.substring(0, n);
            this.remaining = this.remaining.substring(0, ((Matcher)object).start()) + this.remaining.substring(((Matcher)object).end());
        }
        if (this.remaining.length() == 0) {
            return;
        }
        if (this.remaining.indexOf("{{") != -1 && ((Matcher)(object = ARB_TAG_ATT_PATTERN.matcher(this.remaining))).find()) {
            this.arbTagAttr = ((Matcher)object).group(1);
            this.remaining = this.remaining.substring(0, ((Matcher)object).start()) + this.remaining.substring(((Matcher)object).end());
        }
        if (this.remaining.length() == 0) {
            return;
        }
        if (this.remaining.indexOf("{") != -1 && ((Matcher)(object = STYLE_PATTERN.matcher(this.remaining))).find()) {
            this.style = ((Matcher)object).group(1);
            if (!this.style.endsWith(";")) {
                this.style = this.style + ';';
            }
            this.remaining = this.remaining.substring(0, ((Matcher)object).start()) + this.remaining.substring(((Matcher)object).end());
        }
        if (this.remaining.length() == 0) {
            return;
        }
        if (this.remaining.indexOf("[") != -1 && ((Matcher)(object = LANG_PATTERN.matcher(this.remaining))).find()) {
            this.style = ((Matcher)object).group(1);
            this.remaining = this.remaining.substring(0, ((Matcher)object).start()) + this.remaining.substring(((Matcher)object).end());
        }
        if (this.remaining.length() == 0) {
            return;
        }
        if (this.remaining.indexOf(40) != -1 || this.remaining.indexOf(41) != -1) {
            object = new StringBuilder();
            block4: for (int i = 0; i < this.remaining.length(); ++i) {
                n = this.remaining.charAt(i);
                switch (n) {
                    case 40: {
                        ++this.lpad;
                        continue block4;
                    }
                    case 41: {
                        ++this.rpad;
                        continue block4;
                    }
                    default: {
                        ((StringBuilder)object).append((char)n);
                    }
                }
            }
            this.remaining = ((StringBuilder)object).toString();
        }
        if (this.remaining.length() == 0) {
            return;
        }
        int n2 = this.remaining.indexOf("<>");
        if (n2 != -1) {
            this.halign = Halign.both;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 2);
        }
        if ((n2 = this.remaining.indexOf(60)) != -1) {
            this.halign = Halign.left;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
        if ((n2 = this.remaining.indexOf(62)) != -1) {
            this.halign = Halign.right;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
        if ((n2 = this.remaining.indexOf(61)) != -1) {
            this.halign = Halign.center;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
        if ((n2 = this.remaining.indexOf(45)) != -1) {
            this.valign = Valign.middle;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
        if ((n2 = this.remaining.indexOf(94)) != -1) {
            this.valign = Valign.top;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
        if ((n2 = this.remaining.indexOf(126)) != -1) {
            this.valign = Valign.bottom;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
        if ((n2 = this.remaining.indexOf(95)) != -1) {
            this.header = true;
            this.remaining = this.remaining.substring(0, n2) + this.remaining.substring(n2 + 1);
        }
    }

    public void setDefaultId(String string) {
        if (this.id.equals("")) {
            this.setId(string);
        }
    }

    public boolean hasId() {
        return !this.id.equals("");
    }

    public void setId(String string) {
        this.id = string;
        this.changed = true;
    }

    public String getId() {
        return this.id;
    }

    public void setDefaultCssClass(String string) {
        if (this.cssClass.equals("")) {
            this.cssClass = string;
            this.changed = true;
        }
    }

    public void addCssClass(String string) {
        this.cssClass = this.cssClass.equals("") ? string : this.cssClass + " " + string;
        this.changed = true;
    }

    public String tagAttributes() {
        if (this.mods == null || this.mods.equals("") && !this.changed) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.cssClass.equals("")) {
            stringBuilder.append(" class=\"" + this.cssClass.replace(',', ' ') + "\"");
        }
        if (!this.id.equals("")) {
            stringBuilder.append(" id=\"" + this.id + "\"");
        }
        if (!this.lang.equals("")) {
            stringBuilder.append(" lang=\"" + this.lang + "\"");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (!this.style.equals("")) {
            stringBuilder2.append(this.style);
            if (!this.style.endsWith(";")) {
                stringBuilder2.append(';');
            }
        }
        this.styleSymbols(stringBuilder2, stringBuilder);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(" style=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("\"");
        }
        if (!this.arbTagAttr.equals("")) {
            stringBuilder.append(" " + this.arbTagAttr);
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString();
    }

    protected void styleSymbols(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        switch (this.halign) {
            case left: {
                stringBuilder.append("text-align:left;");
                break;
            }
            case right: {
                stringBuilder.append("text-align:right;");
                break;
            }
            case both: {
                stringBuilder.append("text-align:justify;");
                break;
            }
            case center: {
                stringBuilder.append("text-align:center;");
            }
        }
        switch (this.valign) {
            case top: {
                stringBuilder.append("vertical-align:top;");
                break;
            }
            case middle: {
                stringBuilder.append("vertical-align:middle;");
                break;
            }
            case bottom: {
                stringBuilder.append("vertical-align:bottom;");
            }
        }
        if (this.lpad > 0) {
            stringBuilder.append("padding-left:" + this.lpad + "em;");
        }
        if (this.rpad > 0) {
            stringBuilder.append("padding-right:" + this.rpad + "em;");
        }
    }

    public boolean isHeader() {
        return this.header;
    }

    public static class TableCol
    extends Cell {
        private String width = "";

        public TableCol(Task task, String string, String string2) {
            super(task, string);
            if (string2 != null) {
                this.width = string2;
            }
            this.changed = true;
        }

        protected void styleSymbols(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            super.styleSymbols(stringBuilder, stringBuilder2);
            if (!this.colspan.equals("")) {
                stringBuilder2.append(" span=\"" + this.colspan + "\"");
            }
            if (!this.width.equals("")) {
                stringBuilder2.append(" width=\"" + this.width + "\"");
            }
        }
    }

    public static class Cell
    extends Modifiers {
        public Cell(Task task, String string) {
            super(task, string);
        }

        protected void parse() {
            super.parse();
            if (this.remaining == null) {
                return;
            }
            Matcher matcher = COL_SPAN_PATTERN.matcher(this.remaining);
            if (matcher.find()) {
                this.colspan = matcher.group(1);
                this.remaining = this.remaining.substring(0, matcher.start()) + this.remaining.substring(matcher.end());
            }
            if ((matcher = ROW_SPAN_PATTERN.matcher(this.remaining)).find()) {
                this.rowspan = matcher.group(1);
                this.remaining = this.remaining.substring(0, matcher.start()) + this.remaining.substring(matcher.end());
            }
        }

        protected void styleSymbols(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            super.styleSymbols(stringBuilder, stringBuilder2);
            if (!this.rowspan.equals("")) {
                stringBuilder2.append(" rowspan=\"" + this.rowspan + "\"");
            }
            if (!this.colspan.equals("")) {
                stringBuilder2.append(" colspan=\"" + this.colspan + "\"");
            }
        }
    }

    public static class Table
    extends Modifiers {
        public Table(Task task, String string) {
            super(task, string);
        }

        protected void styleSymbols(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            if (!(this.halign != Halign.left && this.halign != Halign.right || this.lpad <= 0 && this.rpad <= 0)) {
                switch (this.halign) {
                    case left: {
                        stringBuilder.append("float:left;");
                        break;
                    }
                    case right: {
                        stringBuilder.append("float:right;");
                    }
                }
                if (this.lpad > 0) {
                    stringBuilder.append("margin-left:" + this.lpad + "em;");
                }
                if (this.rpad > 0) {
                    stringBuilder.append("margin-right:" + this.rpad + "em;");
                }
                switch (this.valign) {
                    case top: {
                        stringBuilder.append("vertical-align:top;");
                        break;
                    }
                    case middle: {
                        stringBuilder.append("vertical-align:middle;");
                        break;
                    }
                    case bottom: {
                        stringBuilder.append("vertical-align:bottom;");
                    }
                }
            } else {
                super.styleSymbols(stringBuilder, stringBuilder2);
                if (this.halign == Halign.center) {
                    stringBuilder.append("margin-right:auto;margin-left:auto;");
                }
            }
        }
    }

    public static class Span
    extends Modifiers {
        public Span(Task task, String string) {
            super(task, string);
        }
    }

    public static class Image
    extends Modifiers {
        public Image(Task task, String string) {
            super(task, string);
        }

        protected void styleSymbols(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            switch (this.halign) {
                case left: {
                    stringBuilder.append("float:left;");
                    break;
                }
                case right: {
                    stringBuilder.append("float:right;");
                }
            }
            switch (this.valign) {
                case top: {
                    stringBuilder.append("vertical-align:text-top;");
                    break;
                }
                case middle: {
                    stringBuilder.append("vertical-align:middle;");
                    break;
                }
                case bottom: {
                    stringBuilder.append("vertical-align:text-bottom;");
                }
            }
            if (this.lpad > 0) {
                stringBuilder.append("padding-left:" + this.lpad + "em;");
            }
            if (this.rpad > 0) {
                stringBuilder.append("padding-right:" + this.rpad + "em;");
            }
        }
    }

    public static class Sig
    extends Modifiers {
        public Sig(Task task, String string) {
            super(task, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Valign {
        top,
        middle,
        bottom,
        unassigned;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Halign {
        left,
        right,
        center,
        both,
        unassigned;

    }
}

