/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import bsh.EvalError;
import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.XilizeException;

public class SigCustom
extends Signature {
    private Block codeBlock;
    private Task owner;
    private int lineNumber;

    public SigCustom(Task task, Block block) throws XilizeException {
        this.name = task.markupKM(block.getLine(0));
        this.lineNumber = block.getLineNumber();
        if (this.name == null || this.name.matches(" *")) {
            throw new XilizeException(task, this.lineNumber, "custom signature name missing");
        }
        if (!this.name.matches("[A-Za-z]+")) {
            throw new XilizeException(task, this.lineNumber, "custom signature name may contain only letters");
        }
        this.owner = task;
        this.codeBlock = block;
    }

    public String translate(Task task, Block block) {
        BeanShell beanShell = task.getBsh();
        String string = null;
        try {
            beanShell.set("sig", this);
            beanShell.set("task", task);
            beanShell.set("block", block);
            beanShell.set("text", block.linesAsString());
            string = beanShell.exec(this.getOwner(), this.codeBlock.getLineNumber(), this.codeBlock.linesAsStringTrim(1));
        }
        catch (EvalError evalError) {
            task.error(block.getLineNumber(), "custom signature translation failed ");
        }
        return string;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Task getOwner() {
        return this.owner;
    }
}

