/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Catalog;
import com.centeredwork.xilize.CatalogListener;
import com.centeredwork.xilize.Env;
import com.centeredwork.xilize.InlineMarkup;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.SigCustom;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.TaskDir;
import com.centeredwork.xilize.TaskFile;
import com.centeredwork.xilize.XilizeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task {
    protected Task parent;
    protected Env env;
    protected HashMap<String, String> defReg = new HashMap();
    protected HashMap<String, String> abbrevReg = new HashMap();
    protected HashMap<String, Signature> sigReg = new HashMap();
    private static final Pattern IS_TRUE_PATTERN = Pattern.compile("(?i)true|yes|1|on");

    public Task(Task task) {
        this.parent = task;
        if (task != null) {
            this.env = task.getEnv();
        }
    }

    void xilize() throws XilizeException {
    }

    public Task getParent() {
        return this.parent;
    }

    public File getFile() {
        return null;
    }

    public Env getEnv() {
        return this.env;
    }

    public boolean isHalted() {
        return this.env.isHalted();
    }

    public BeanShell getBsh() {
        return this.env.getBsh();
    }

    public boolean isNatural() {
        return this.isValueTrue(Key._Natural_.name());
    }

    public String getDescription() {
        return "undefined task";
    }

    public String toString() {
        return this.getDescription();
    }

    public String getPath() {
        return "";
    }

    public boolean isDefined(Key key) {
        return this.isDefined(key.name());
    }

    public String value(Key key) {
        return this.value(key.name());
    }

    public void define(Key key, String string) {
        this.define(key.name(), string);
    }

    public void defineAppend(Key key, String string) {
        this.defineAppend(key.name(), string);
    }

    public boolean isValueTrue(Key key) {
        return this.isValueTrue(key.name());
    }

    public void undef(Key key) {
        this.undef(key.name());
    }

    public Signature getSignature(Key key) {
        return this.getSignature(key.name());
    }

    public boolean isDefined(String string) {
        if (this.defReg.containsKey(string)) {
            return !this.defReg.get(string).equals("");
        }
        return this.parent == null ? false : this.parent.isDefined(string);
    }

    protected boolean _isDefined(String string) {
        return this.defReg.containsKey(string) && !this.defReg.get(string).equals("");
    }

    protected boolean parentHasDefined(Key key) {
        return this.parent == null ? false : this.parent._isDefined(key.name());
    }

    public String value(String string) {
        if (this.defReg.containsKey(string) && this.defReg.get(string).equals("")) {
            return "";
        }
        if (!this.defReg.containsKey(string)) {
            return this.parent == null ? "" : this.parent.value(string);
        }
        return this.defReg.get(string);
    }

    public void define(String string, String string2) {
        if (string2.startsWith("&{literal:") && string2.endsWith("}")) {
            string2 = string2.substring("&{literal:".length(), string2.length() - 1);
        }
        string2 = this.markupKM(string2);
        this.defReg.put(string, string2);
    }

    public void undef(String string) {
        if (string.equals("")) {
            return;
        }
        if (this.isDefined(string)) {
            this.define(string, "");
        }
    }

    public void defineAppend(String string, String string2) {
        this.define(string, this.value(string) + string2);
    }

    public void defineDefault(String string, String string2) {
        if (!this.isDefined(string)) {
            this.define(string, string2);
        }
    }

    public void define(HashMap<String, String> hashMap) {
        if (hashMap == null) {
            return;
        }
        this.defReg.putAll(hashMap);
    }

    public boolean isValueTrue(String string) {
        String string2 = this.value(string);
        return IS_TRUE_PATTERN.matcher(string2).matches();
    }

    public void addSig(Signature signature) {
        Signature signature2 = this._getSignature(signature.getName());
        if (signature2 != null && this.isValueTrue(Key._WarnOnSigOverride_)) {
            if (signature instanceof SigCustom) {
                this.warning(((SigCustom)signature).getLineNumber(), "signature override: " + signature.getName() + (signature2 instanceof SigCustom ? " is also defined in " + ((SigCustom)signature2).getOwner().getPath() : " is also native signature"));
            } else {
                throw new IllegalStateException("signature overwritten");
            }
        }
        this.sigReg.put(signature.getName(), signature);
    }

    public Signature getSignature(String string) {
        Signature signature = this._getSignature(string);
        if (signature == null) {
            signature = this._getSignature(this.value("_unsignedBlockSig_"));
        }
        if (signature == null) {
            this.error("signature " + string + " is null");
            throw new IllegalStateException("null signature");
        }
        return signature.copy();
    }

    Signature _getSignature(String string) {
        if (this.sigReg.containsKey(string)) {
            return this.sigReg.get(string);
        }
        return this.parent == null ? null : this.parent._getSignature(string);
    }

    public String markup(String string) {
        return this.env.getInline().translate(this, string);
    }

    public String markupKM(String string) {
        return this.env.getInline().translateKM(this, string);
    }

    public String markup(Block block) {
        return this.env.getInline().translate(block);
    }

    public String markupKeepEOL(Block block) {
        return this.env.getInline().translateKeepNL(block);
    }

    public String markupKeepEOL(int n, Block block) {
        return this.env.getInline().translateKeepNL(block, block.wrapLines(n));
    }

    public String markupU(Block block) {
        this.env.getInline();
        return InlineMarkup.replaceUnkindChar(block.linesAsString());
    }

    public String markupU(String string) {
        this.env.getInline();
        return InlineMarkup.replaceUnkindChar(string);
    }

    public void addAbbrev(String string, String string2) {
        this.abbrevReg.put(string, string2);
    }

    public String getUrl(String string) {
        if (this.abbrevReg.containsKey(string)) {
            return this.abbrevReg.get(string);
        }
        return this.parent == null ? null : this.parent.getUrl(string);
    }

    public void addCatalogListener(CatalogListener catalogListener) {
        if (this instanceof TaskFile) {
            ((TaskFile)this).catalog.addListener(catalogListener);
        }
    }

    public boolean hasListener(Catalog.Item item) {
        return this instanceof TaskFile ? ((TaskFile)this).catalog.hasListener((TaskFile)this, item) : false;
    }

    public void register(Catalog.Item item) {
        if (this instanceof TaskFile) {
            ((TaskFile)this).catalog.register((TaskFile)this, item);
        }
    }

    public String uniqueId() {
        if (this instanceof TaskFile) {
            return ((TaskFile)this).catalog.uniqueId();
        }
        return "";
    }

    private void _report(String string) {
        if (this.isValueTrue("_Silent_")) {
            return;
        }
        this.env.getReporter().report(string);
    }

    public void report(String string) {
        this._report(string);
    }

    private void _warning(String string) {
        if (this.isValueTrue("_NoWarn_")) {
            return;
        }
        this.env.getReporter().warn(string);
    }

    public void warning(String string) {
        this._warning(string);
    }

    public void warning(int n, String string) {
        this._warning(this.getPath() + ":" + n + ":warning: " + string);
    }

    private void _debug(String string) {
        if (this.isValueTrue("_Debug_")) {
            this.env.getReporter().debug(string);
        }
    }

    public void debug(String string) {
        this._debug(string);
    }

    public void debug(int n, String string) {
        this._debug(this.getPath() + ":" + n + ":" + string);
    }

    public void _error(String string) {
        this.env.getReporter().error(string);
    }

    public void error(String string) {
        this._error(this.getDescription() + ":" + string);
    }

    public void error(int n, String string) {
        this._error(this.getPath() + ":" + n + ":" + string);
    }

    public void error(String string, Exception exception) {
        this._error(this.getDescription() + ": " + string + ": " + exception.getMessage());
    }

    public int getErrors() {
        return this.env.getReporter().getErrors();
    }

    public int getWarnings() {
        return this.env.getReporter().getWarnings();
    }

    public void loadProperties(File file) throws IllegalArgumentException, IOException {
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(file)));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.define(string, (String)properties.get(string));
        }
    }

    public boolean isDirectory() {
        return this instanceof TaskDir;
    }

    public TaskDir parentDir() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.isDirectory()) {
            return (TaskDir)this.parent;
        }
        return this.parent.parentDir();
    }

    public int getDepth() {
        TaskDir taskDir = this.parentDir();
        return taskDir == null ? -1 : ((Task)taskDir).getDepth();
    }

    public String[] sigNames() {
        Set<String> set = this.sigReg.keySet();
        Object[] objectArray = set.toArray(new String[set.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }
}

