(ns lua.core.posix
  (:require [std.lib :as h]
            [std.lang :as l]
            [std.string :as str]
            [xt.lang.base-repl :as repl])
  (:refer-clojure :exclude [print flush time re-find read send sync]))

(l/script :lua
  {:macro-only true
   :bundle   {:default [["posix" :as posix]]}
   :import  [["posix" :as posix]]})

(def +methods+
  '[LOG_MASK
    S_ISBLK
    S_ISCHR
    S_ISDIR
    S_ISFIFO
    S_ISLNK
    S_ISREG
    S_ISSOCK
    _exit
    abort
    accept
    access
    alarm
    basename
    bind
    chdir
    chmod
    chown
    clock_getres
    clock_gettime
    close
    closelog
    connect
    creat
    crypt
    ctermid
    dir
    dirname
    dup
    dup2
    endgrent
    endpwent
    errno
    euidaccess
    exec
    execp
    execx
    fadvise
    fcntl
    fdatasync
    fdopen
    fileno
    files
    fnmatch
    fork
    fstat
    fsync
    ftruncate
    getaddrinfo
    getcwd
    getegid
    getenv
    geteuid
    getgid
    getgrent
    getgrgid
    getgrnam
    getgroup
    getgroups
    gethostid
    getlogin
    getopt
    getpasswd
    getpeername
    getpgrp
    getpid
    getppid
    getpwent
    getpwnam
    getpwuid
    getrlimit
    getsockname
    getsockopt
    gettimeofday
    getuid
    glob
    gmtime
    grantpt
    hostid
    if_nametoindex
    isatty
    isgraph
    isprint
    kill
    killpg
    lchown
    link
    linkat
    listen
    localtime
    lseek
    lstat
    mkdir
    mkdtemp
    mkfifo
    mkstemp
    mktime
    msgctl
    msgget
    msgrcv
    msgsnd
    nanosleep
    nice
    open
    openlog
    openpt
    openpty
    pathconf
    pclose
    pipe
    poll
    popen
    popen_pipeline
    posix_fadvise
    ptsname
    raise
    read
    readlink
    realpath
    recv
    recvfrom
    rename
    rmdir
    rpoll
    sched_getscheduler
    sched_setscheduler
    send
    sendto
    set_errno
    setenv
    setgrent
    setlogmask
    setpid
    setpwent
    setrlimit
    setsockopt
    shutdown
    signal
    sleep
    socket
    socketpair
    spawn
    stat
    statvfs
    strftime
    strptime
    sync
    sysconf
    syslog
    tcdrain
    tcflow
    tcflush
    tcgetattr
    tcgetpgrp
    tcsendbreak
    tcsetattr
    tcsetpgrp
    time
    timeradd
    timercmp
    timersub
    times
    truncate
    ttyname
    umask
    uname
    unlink
    unlockpt
    utime
    wait
    write])

(h/template-entries [l/tmpl-entry {:type :fragment
                                   :base "posix"
                                   :tag "lua"}]
  +methods+)
