/*
 * Decompiled with CFR 0.152.
 */
package hara.net.resp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SocketConnection
implements Closeable {
    public final Encoder writer;
    public final Parser reader;
    public Socket socket;

    public SocketConnection(Socket socket) throws IOException {
        this(socket, 65536, 65536);
    }

    public SocketConnection(Socket socket, int n, int n2) throws IOException {
        this(new BufferedInputStream(socket.getInputStream(), n), new BufferedOutputStream(socket.getOutputStream(), n2));
        this.socket = socket;
    }

    private SocketConnection(InputStream inputStream, OutputStream outputStream) {
        this.reader = new Parser(inputStream);
        this.writer = new Encoder(outputStream);
    }

    public <T> T call(Object ... objectArray) throws IOException {
        this.write(objectArray);
        return this.read();
    }

    public <T> T read() throws IOException {
        return (T)this.reader.parse();
    }

    public void write(Object ... objectArray) throws IOException {
        this.writer.write(Arrays.asList(objectArray));
        this.writer.flush();
    }

    public void write(long l) throws IOException {
        this.writer.write(l);
        this.writer.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.writer.write(byArray);
        this.writer.flush();
    }

    public void write(Throwable throwable) throws IOException {
        this.writer.write(throwable);
        this.writer.flush();
    }

    public void writeString(String string) throws IOException {
        this.writer.writeString(string);
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public Pipeline pipeline() {
        return new Pipeline(){
            private int n = 0;

            @Override
            public int counter() {
                return this.n;
            }

            @Override
            public Pipeline call(Object ... objectArray) throws IOException {
                SocketConnection.this.writer.write(Arrays.asList(objectArray));
                SocketConnection.this.writer.flush();
                ++this.n;
                return this;
            }

            @Override
            public List<Object> read() throws IOException {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                while (this.n-- > 0) {
                    linkedList.add(SocketConnection.this.reader.parse());
                }
                return linkedList;
            }
        };
    }

    public static abstract class Pipeline {
        public abstract Pipeline call(Object ... var1) throws IOException;

        public abstract List<Object> read() throws IOException;

        public abstract int counter();
    }

    static class Parser {
        private final InputStream input;

        Parser(InputStream inputStream) {
            this.input = inputStream;
        }

        Object parse() throws IOException, ProtocolException {
            Object object;
            int n = this.input.read();
            switch (n) {
                case 43: {
                    object = this.parseSimpleString();
                    break;
                }
                case 45: {
                    object = new ServerError(new String(this.parseSimpleString()));
                    break;
                }
                case 58: {
                    object = this.parseNumber();
                    break;
                }
                case 36: {
                    object = this.parseBulkString();
                    break;
                }
                case 42: {
                    long l = this.parseNumber();
                    if (l == -1L) {
                        object = null;
                        break;
                    }
                    LinkedList<Object> linkedList = new LinkedList<Object>();
                    for (long i = 0L; i < l; ++i) {
                        linkedList.add(this.parse());
                    }
                    object = linkedList;
                    break;
                }
                case -1: {
                    return null;
                }
                default: {
                    throw new ProtocolException("Unexpected input: " + (byte)n);
                }
            }
            return object;
        }

        private byte[] parseBulkString() throws IOException, ProtocolException {
            long l = this.parseNumber();
            if (l == -1L) {
                return null;
            }
            if (l > Integer.MAX_VALUE) {
                throw new ProtocolException("Unsupported value length for bulk string");
            }
            int n = (int)l;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while ((long)n2 < l) {
                n2 += this.input.read(byArray, n2, n - n2);
            }
            if (this.input.read() != 13) {
                throw new ProtocolException("Expected CR");
            }
            if (this.input.read() != 10) {
                throw new ProtocolException("Expected LF");
            }
            return byArray;
        }

        private byte[] parseSimpleString() throws IOException {
            return this.scanCr(1024);
        }

        private long parseNumber() throws IOException {
            return Long.valueOf(new String(this.scanCr(1024)));
        }

        private byte[] scanCr(int n) throws IOException {
            int n2;
            int n3 = 0;
            byte[] byArray = new byte[n];
            while ((n2 = this.input.read()) != 13) {
                byArray[n3++] = (byte)n2;
                if (n3 != n) continue;
                byArray = Arrays.copyOf(byArray, n *= 2);
            }
            if (this.input.read() != 10) {
                throw new ProtocolException("Expected LF");
            }
            return Arrays.copyOfRange(byArray, 0, n3);
        }

        static class ServerError
        extends IOException {
            ServerError(String string) {
                super(string);
            }
        }

        static class ProtocolException
        extends IOException {
            ProtocolException(String string) {
                super(string);
            }
        }
    }

    static class Encoder {
        private static byte[] CRLF = new byte[]{13, 10};
        private final OutputStream out;

        Encoder(OutputStream outputStream) {
            this.out = outputStream;
        }

        void write(byte[] byArray) throws IOException {
            this.out.write(36);
            this.out.write(Long.toString(byArray.length).getBytes());
            this.out.write(CRLF);
            this.out.write(byArray);
            this.out.write(CRLF);
        }

        void write(long l) throws IOException {
            this.out.write(58);
            this.out.write(Long.toString(l).getBytes());
            this.out.write(CRLF);
        }

        void write(Throwable throwable) throws IOException {
            this.out.write(45);
            this.out.write(throwable.getMessage().getBytes());
            this.out.write(CRLF);
        }

        void write(List<?> list) throws IOException, IllegalArgumentException {
            this.out.write(42);
            this.out.write(Long.toString(list.size()).getBytes());
            this.out.write(CRLF);
            for (Object obj : list) {
                if (obj instanceof byte[]) {
                    this.write((byte[])obj);
                    continue;
                }
                if (obj instanceof String) {
                    this.write(((String)obj).getBytes());
                    continue;
                }
                if (obj instanceof Long) {
                    this.write((Long)obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    this.write(((Integer)obj).longValue());
                    continue;
                }
                if (obj instanceof Throwable) {
                    this.write((Throwable)obj);
                    continue;
                }
                if (obj instanceof List) {
                    this.write((List)obj);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type " + obj.getClass().getCanonicalName());
            }
        }

        void writeString(String string) throws IOException {
            this.out.write(43);
            this.out.write(string.getBytes());
            this.out.write(CRLF);
        }

        void flush() throws IOException {
            this.out.flush();
        }
    }
}

